% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLContext.R
\name{dropTempView}
\alias{dropTempView}
\title{Drops the temporary view with the given view name in the catalog.}
\usage{
dropTempView(viewName)
}
\arguments{
\item{viewName}{the name of the view to be dropped.}
}
\value{
TRUE if the view is dropped successfully, FALSE otherwise.
}
\description{
Drops the temporary view with the given view name in the catalog.
If the view has been cached before, then it will also be uncached.
}
\note{
since 2.0.0
}
\examples{
\dontrun{
sparkR.session()
df <- read.df(path, "parquet")
createOrReplaceTempView(df, "table")
dropTempView("table")
}
}
