% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{date_format}
\alias{date_format}
\alias{date_format}
\alias{date_format,Column,character-method}
\title{date_format}
\usage{
date_format(y, x)

\S4method{date_format}{Column,character}(y, x)
}
\arguments{
\item{y}{Column to compute on.}

\item{x}{date format specification.}
}
\description{
Converts a date/timestamp/string to a value of string in the format specified by the date
format given by the second argument.
}
\details{
A pattern could be for instance \preformatted{dd.MM.yyyy} and could return a string like '18.03.1993'. All
pattern letters of \code{java.text.SimpleDateFormat} can be used.

Note: Use when ever possible specialized functions like \code{year}. These benefit from a
specialized implementation.
}
\note{
date_format since 1.5.0
}
\examples{
\dontrun{date_format(df$t, 'MM/dd/yyy')}
}
\seealso{
Other datetime_funcs: \code{\link{add_months}},
  \code{\link{date_add}}, \code{\link{date_sub}},
  \code{\link{datediff}}, \code{\link{dayofmonth}},
  \code{\link{dayofyear}}, \code{\link{from_unixtime}},
  \code{\link{from_utc_timestamp}}, \code{\link{hour}},
  \code{\link{last_day}}, \code{\link{minute}},
  \code{\link{months_between}}, \code{\link{month}},
  \code{\link{next_day}}, \code{\link{quarter}},
  \code{\link{second}}, \code{\link{to_date}},
  \code{\link{to_utc_timestamp}},
  \code{\link{unix_timestamp}}, \code{\link{weekofyear}},
  \code{\link{window}}, \code{\link{year}}
}
