% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{.wrap.simList}
\alias{.wrap.simList}
\alias{.unwrap.simList}
\title{Methods for \code{.wrap} and \code{.unwrap}}
\usage{
\method{.wrap}{simList}(
  obj,
  cachePath,
  preDigest,
  drv = getOption("reproducible.drv", NULL),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  ...
)

\method{.unwrap}{simList}(
  obj,
  cachePath,
  cacheId,
  drv = getOption("reproducible.drv", NULL),
  conn = getOption("reproducible.conn", NULL),
  ...
)
}
\arguments{
\item{obj}{Any arbitrary R object.}

\item{cachePath}{A repository used for storing cached objects.
This is optional if \code{Cache} is used inside a SpaDES module.}

\item{preDigest}{The list of \code{preDigest} that comes from \code{CacheDigest} of an object}

\item{drv}{an object that inherits from \code{DBIDriver}, or an existing
\code{DBIConnection} object (in order to clone an existing connection).}

\item{conn}{A \code{DBIConnection} object, as returned by \code{dbConnect()}.}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}

\item{...}{Other arguments. Currently, \code{regexp}, a logical, can be provided.
This must be \code{TRUE} if the use is passing a regular expression.
Otherwise, \code{userTags} will need to be exact matches. Default is
missing, which is the same as \code{TRUE}. If there are errors due
to regular expression problem, try \code{FALSE}. For \code{cc}, it is
passed to \code{clearCache}, e.g., \code{ask}, \code{userTags}. For \code{showCache},
it can also be \code{sorted = FALSE} to return the object unsorted.}

\item{cacheId}{Used strictly for messaging. This should be the cacheId of the object being recovered.}
}
\value{
The same object as passed into the function, but dealt with so that it can be
saved to disk.
}
\description{
Methods for \code{.wrap} and \code{.unwrap}
}
