% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spe.R
\name{plot.spe}
\alias{plot.spe}
\title{Plot output of \code{\link{spe}} command. The x-axis limits are set to the
specified range of percentile index.}
\usage{
\method{plot}{spe}(x, ylim = NULL, main = NULL, sub = NULL,
  xlab = "Percentile Index", ylab = "Sorted Effects", ...)
}
\arguments{
\item{x}{Output of \code{\link{spe}} command.}

\item{ylim}{y-axis limits. Default is NULL.}

\item{main}{Main title of the plot. Defualt is NULL.}

\item{sub}{Sub title of the plot. Default is NULL.}

\item{xlab}{x-axis label. Default is "Percentile Index".}

\item{ylab}{y-axis label. Default is "Sorted Effects".}

\item{...}{graphics parameters to be passed to the plotting
routines.}
}
\description{
Plot output of \code{\link{spe}} command. The x-axis limits are set to the
specified range of percentile index.
}
\examples{
data("mortgage")
fm <- deny ~ black + p_irat + hse_inc + ccred + mcred + pubrec + ltv_med +
ltv_high + denpmi + selfemp + single + hischl
test <- spe(fm = fm, data = mortgage, var = "black", method = "logit",
us = c(2:98)/100, b = 50)

plot(x = test, main="APE and SPE of Being Black on the prob of
Mortgage Denial", sub="Logit Model", ylab="Change in Probability")

}
