% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Subpop.R
\name{Subpop}
\alias{Subpop}
\title{Inference on Most and Least Affected Groups}
\usage{
Subpop(fm, data, method = "ols", var.type = "binary", var.T, compare,
  subgroup = NULL, samp_weight = NULL, taus = c(1:9)/10, u = 0.1,
  alpha = 0.1, B = 10, ncores = 1, seed = 1,
  boot.type = "nonpar")
}
\arguments{
\item{fm}{Regression formula}

\item{data}{The data in use}

\item{method}{Models to be used for estimating partial effects. Four options: \code{"logit"} (binary response),
\code{"probit"} (binary response), \code{"ols"} (interactive linear with additive errors), \code{"QR"} (linear model
with non-additive errors). Default is \code{"ols"}.}

\item{var.type}{The type of parameter in interest. Three options: \code{"binary"}, \code{"categorical"}, \code{"continuous"}. Default
is \code{"binary"}.}

\item{var.T}{Variable T in interset. Should be a character.}

\item{compare}{If parameter in interest is categorical, then user needs to specify which two category to
compare with. Should be a 1 by 2 character vector. For example, if the two levels to compare
with is 1 and 3, then \code{c=("1", "3")}, which will calculate partial effect from 1 to 3. To use
this option, users first need to specify var.T as a factor variable.}

\item{subgroup}{Subgroup in interest. Default is \code{NULL}. Specifcation should be a logical variable. For example, suppose data contains
indicator variable for women (female if 1, male if 0). If users are interested in women SPE, then users
should specify \code{subgroup = data[, "female"] == 1}.}

\item{samp_weight}{Sampling weight of data. If null then function implements empirical bootstrap.
If data specifies sampling weight, put that in and the function implements
weighted (i.i.d exponential weights) bootstrap.}

\item{taus}{Indexes for quantile regression. Default is \code{c(1:9)/10}.}

\item{u}{Percentile of most and least affected. Default is set to be 0.1.}

\item{alpha}{Size for confidence interval. Shoule be between 0 and 1. Default is 0.1}

\item{B}{Number of bootstrap draws. Default is set to be 10. For more accurate results, we recommend 500.}

\item{ncores}{Number of cores for computation. Default is set to be 1. For large dataset, parallel computing
is highly recommended since bootstrap is time-consuming.}

\item{seed}{Pseudo-number generation for reproduction. Default is 1.}

\item{boot.type}{Type of bootstrap. Default is \code{boot.type = "nonpar"}, and the package implements nonparametric
bootstrap. An alternative is \code{boot.type = "weighted"}, and the package implements weighted
bootstrap.}
}
\description{
\code{Subpop} conducts set inference on the groups of most and least affected. When \code{subgroup = NULL}, output is for whole sample.
Otherwise the results are subgroup. The results can be visualized using the
\code{\link{Subpopplot}} command. The output of \code{Subpop} is a list containing four components: \code{most}, \code{least}, \code{u} and \code{sub}.
As the names indicate, \code{most} and \code{least} denote the confidence sets for the most and least affected units. \code{u} stores the u-th most
and least affected index and \code{sub} stores the indicators for subpopulations.
}
\examples{
data("mortgage")
fm <- deny ~ black + p_irat + hse_inc
result <- Subpop(fm = fm, data = mortgage, var.T = "black", method = "logit")

}
