% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge-clin.R
\name{merge_clin}
\alias{merge_clin}
\title{Merge Clinical Data into SomaScan}
\usage{
merge_clin(x, clin_data, by = NULL, by_class = NULL, ...)
}
\arguments{
\item{x}{A \code{soma_adat} object (with intact attributes),
typically created using \code{\link[=read_adat]{read_adat()}}.}

\item{clin_data}{One of 2 options:
\itemize{
\item a data frame containing clinical variables to merge into \code{x}, or
\item a path to a file, typically a \verb{*.csv},
containing clinical variables to merge into \code{x}.
}}

\item{by}{A character vector of variables to join by.
See \code{\link[dplyr:mutate-joins]{dplyr::left_join()}} for more details.}

\item{by_class}{If \code{clin_data} is a file path, a named character vector
of the variable and its class. This ensures the "by-key" is compatible
for the join. For example, \code{c(SampleId = "character")}.
See \code{\link[=read.table]{read.table()}} for details about its \code{colClasses} argument, and
also the examples below.}

\item{...}{Additional parameters passed to \code{\link[dplyr:mutate-joins]{dplyr::left_join()}}.}
}
\value{
A \code{soma_adat} with new clinical variables merged.
}
\description{
Occasionally, additional clinical data is obtained \emph{after} samples
have been submitted to SomaLogic, or even after 'SomaScan'
results have been delivered.
This requires the new clinical variables, i.e. non-proteomic, data to be
merged with 'SomaScan' data into a "new" ADAT prior to analysis.
\code{\link[=merge_clin]{merge_clin()}} easily merges such clinical variables into an
existing \code{soma_adat} object and is a simple wrapper around \code{\link[dplyr:mutate-joins]{dplyr::left_join()}}.
}
\details{
This functionality also exists as a command-line tool (R script) contained
in \code{merge_clin.R} that lives in the \code{cli/merge} system file directory.
Please see:
\itemize{
\item \code{dir(system.file("cli/merge", package = "SomaDataIO"), full.names = TRUE)}
\item \code{vignette("cli-merge-tool", package = "SomaDataIO")}
}
}
\examples{
# retrieve clinical data
clin_file <- system.file("cli/merge", "meta.csv",
                         package = "SomaDataIO",
                         mustWork = TRUE)
clin_file

# view clinical data to be merged:
# 1) `group`
# 2) `newvar`
clin_df <- read.csv(clin_file, colClasses = c(SampleId = "character"))
clin_df

# create mini-adat
apts <- withr::with_seed(123, sample(getAnalytes(example_data), 2L))
adat <- head(example_data, 9L) |>   # 9 x 2
  dplyr::select(SampleId, all_of(apts))

# merge clinical variables
merged <- merge_clin(adat, clin_df, by = "SampleId")
merged

# Alternative syntax:
#   1) pass file path
#   2) merge on different variable names
#   3) convert join type on-the-fly
clin_file2 <- system.file("cli/merge", "meta2.csv",
                          package = "SomaDataIO",
                          mustWork = TRUE)

id_type <- typeof(adat$SampleId)
merged2 <- merge_clin(adat, clin_file2,                # file path
                      by = c(SampleId = "ClinKey"),    # join on 2 variables
                      by_class = c(ClinKey = id_type)) # match types
merged2
}
\seealso{
\code{\link[dplyr:mutate-joins]{dplyr::left_join()}}
}
\author{
Stu Field
}
