% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEM.R
\name{SEM}
\alias{SEM}
\title{Simplified evaporation method (SEM)}
\usage{
SEM(suc.up, suc.low, weight = NULL, t, ths = NULL, r = 3.6, L = 6,
  z1 = 1.5, z2 = 4.5, sd.tens = 0.2, suc.negativ = TRUE,
  suc.out = "weighted")
}
\arguments{
\item{suc.up}{a numeric vector containing the measured suctions [cm] of the upper tensiometer}

\item{suc.low}{a numeric vector containing the measured suctions [cm] of the lower tensiometer}

\item{weight}{a numeric vector containing the measured weights [g]}

\item{t}{time in seconds [s]}

\item{ths}{saturated water content (optional) for the calulation of the soil water contents (th)}

\item{r}{sample radius [cm]}

\item{L}{sample height [cm]}

\item{z1}{depth of upper tensiometer [cm]}

\item{z2}{depth of lower tensiometer [cm]}

\item{sd.tens}{measurement accuracy of tensiometer [cm]}

\item{suc.negativ}{set TRUE if suction/tensiometer values are negative and FALSE if positive}

\item{suc.out}{'weighted' (default), arithmetic ('ari') or geometric ('geo') mean of the tensiometer readings (see Peters (2015) for details)}
}
\value{
\describe{\item{data.frame}{}
\item{}{Ki: unsaturated hydraulic conductivity [cm/day]}
\item{}{th: water content (th) is returned if ths is provided as input}
\item{}{suc: suction, either (1) weighted between arithmetic and geometric mean (default), (2) the arithmetic mean or (3) the geometric mean (see Peters 2015)}}
}
\description{
Determines unsaturated hydraulic conductivity and water retention characteristics from laboratory evaporation experiments.
}
\details{
\describe{\item{sd.tens:}{
At the beginning of the experiment when gradients of the hydraulic head are small, hydraulic conductivities cannot be calculated. Following Peters and Durner (2008) hydraulic conductivities calculated from gradients smaller than (6*sd.tens)/(z2-z1) are set to NA.}}
}
\examples{
# ----------------------------------------------------------------------------
# Calculate hydraulic properties with the 'Simplified Evaporation Method' (SEM)
# ----------------------------------------------------------------------------
data('dataSEM')
ths <- 0.7  # define saturated water content (ths) (optional)
shp <- SEM(suc.up     = dataSEM$tens.up,
          suc.low     = dataSEM$tens.low,
          weight      = dataSEM$weight,
          t           = dataSEM$hour*60*60,
          r           = 3.6, # radius of sample
          L           = 6,   # height of sample
          z1          = 1.5, # depth of upper tensiometer [cm]
          z2          = 4.5, # depth of lower tensiometer [cm]
          sd.tens     = 0.1,  # tensiometer accuracy (see ?SEM)
          ths         = ths,
          suc.negativ = TRUE,
          suc.out     = 'weighted'
)
}
\references{
Wind, G. P. (1966). Capillary conductivity data estimated by a simple method (No. 80). [sn].

Peters, A., Iden, S. C., & Durner, W. (2015). Revisiting the simplified evaporation method: Identification of hydraulic functions considering vapor, film and corner flow. Journal of Hydrology, 527, 531-542.

Peters, A., & Durner, W. (2008). Simplified evaporation method for determining soil hydraulic properties. Journal of Hydrology, 356(1), 147-162.

Schindler, U., 1980. Ein Schnellverfahren zur Messung der Wasserleitfähigkeit im teilgesättigten Boden an Stechzylinderproben. Arch. Acker- Pflanzenbau Bodenkd. 24, 1–7.
}
\author{
Ullrich Dettmann
}
