% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertErrorBar.R
\name{vertErrorBar}
\alias{vertErrorBar}
\title{Draw vertical error bar(s) on a plot}
\usage{
vertErrorBar(x, width, center = NULL, barLength = NULL, min.y = NULL,
  max.y = NULL, blankMiddle = NULL, ...)
}
\arguments{
\item{x}{Vector of x value on the plot around which the vertical error bar will be drawn}

\item{width}{The total width of the cross hatches on top and bottom of the bars, can
be a vector or a single value}

\item{center}{Vector of values designating the vertical center of the error bars, can
be a vector or a single value}

\item{barLength}{The total vertical length of the bars, can be a vector or a single value}

\item{min.y}{Vector of values indicating the vertical bottoms of the bars}

\item{max.y}{Vector of values indicating the vertical tops of the bars}

\item{blankMiddle}{the vertical length of a blank spot that will be produced in the middle of
the error bar. This is useful when the bar is placed around symbols (so as not to overwrite them).
Defaults to \code{NULL}, in which case a solid error bar is drawn. Can also be a vector or a
single value.}

\item{\dots}{additional arguments to \code{\link{lines}}.}
}
\value{
Nothing is returned, the error bar(s) is/are drawn on the plot
}
\description{
Draw vertical error bar(s) on a plot
}
\details{
Buyer beware!  It's up to the user to determine what the statistically correct length
of the error bar should be.

Either \code{center} and \code{barLength} must be specified, or \code{min.y} and
\code{max.y} must be specifed.

Note that \code{width}, \code{center}, \code{barLength}, \code{min.y}, \code{max.y}, 
and \code{blankMiddle} should be \code{NULL}, numeric values of length 1, or numeric values with
the same length as \code{x}.  If they have the same length of \code{x}, the bars can have
different vertical lengths, widths, and \code{blankMiddle} values if desired.
}
\examples{
set.seed(343)

# Make a plot of some standard normal observations
x <- 1:9
y <- rnorm(9)

plot(x, y, pch = as.character(1:9), ylim = c(-2, 2) + range(y),
     ylab = "Z", xlab = "Indexes")

# Draw the error bars
vertErrorBar(x, 0.3, center = y, barLength = 2 * 1.96, blankMiddle = 0.25)
}
\author{
Landon Sego
}
