% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_PrepareFeatureSet.R
\name{prepareFeatureSet}
\alias{prepareFeatureSet}
\title{Compiles a list of features from energy consumption data}
\usage{
prepareFeatureSet(
  features.granularity = NA,
  features.w_adj = FALSE,
  features.anonymized = FALSE,
  features.categorical = FALSE,
  features.geo = "osm-v1",
  features.temperature = TRUE,
  features.weather = TRUE,
  features.neighborhood = FALSE
)
}
\arguments{
\item{features.granularity}{Character: The granularity of the input data, either "15-min" (only 15-min features), "30-min" (only 30-minute features),
"all_30min_to_week" (all features on daily, weekly, hourly, ..., up to 30-min data), "all_15_week" (all up to 15-min dara),
"week" (only the consumption of one week as a single feature).}

\item{features.w_adj}{Boolean: are the features to be weather adjusted with DiD-Class
(NOT IMPLEMENTED YET!)}

\item{features.anonymized}{Boolean: are anonymized geographic features used
(NOT IMPLEMENTED YET!)}

\item{features.categorical}{Boolean: use categorical features additionally (if only numeric
features are used)}

\item{features.geo}{Character: Version of the geographic feature set (either "none", "osm-v1", "osm-v2")}

\item{features.temperature}{Boolean, if features for the temperature should be included}

\item{features.weather}{Boolean, if other weather features should be included}

\item{features.neighborhood}{Boolean, if features for the neighborhood should be included}
}
\value{
Character vector
}
\description{
Returns a vector of feature names that can be calculated by methods in the
*SmartMeterAnalytics* package obtains the feature set according
}
\references{
Hopf, K. (2019). Predictive Analytics for Energy Efficiency and
    Energy Retailing (1st ed.). Bamberg: University of Bamberg.
    \url{https://doi.org/10.20378/irbo-54833}

Hopf, K., Sodenkamp, M., Kozlovskiy, I., & Staake, T. (2014).
    Feature extraction and filtering for household classification based on
    smart electricity meter data. Computer Science-Research and Development,
    (31) 3, 141–148. \url{https://doi.org/10.1007/s00450-014-0294-4}

Hopf, K., Sodenkamp, M., & Staake, T. (2018). Enhancing energy
    efficiency in the residential sector with smart meter data analytics.
    Electronic Markets, 28(4). \url{https://doi.org/10.1007/s12525-018-0290-9}

Beckel, C., Sadamori, L., Staake, T., & Santini, S. (2014).
    Revealing household characteristics from smart meter data. Energy, 78,
    397–410. \url{https://doi.org/10.1016/j.energy.2014.10.025}
}
\author{
Konstantin Hopf \email{konstantin.hopf@uni-bamberg.de}
}
