% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ss.data.wby}
\alias{ss.data.wby}
\title{Woodboard profiles}
\format{
A matrix with 500 rows (locations) and 50 columns (woodboard).
}
\source{
Example 10.1 in the reference below. It is a variation of the one
introduced by Walker (2002).
}
\usage{
data("ss.data.wby")
}
\description{
This data set contains 50 profiles corresponding to the density measurements
of 50 0.5\emph{in}-thick engineered woodboard, measured in 500 locations.
}
\details{
This data set illustrates concepts in the book ``Quality Control with R''.
This data set should be used along with the \code{\link{ss.data.wbx}} data
set.
}
\examples{

data(ss.data.wbx)
data(ss.data.wby)
plotProfiles(profiles = ss.data.wby,
    x = ss.data.wbx)
}
\references{
Cano, E.L. and Moguerza, J.M. and Prieto Corcoba, M. (2015)
\emph{Quality Control with R. An ISO Standards Approach}. Springer.

Walker, E. amd Wright, W (2002) Comparing curves with additive models.
\emph{J. Qual. Technol.} \bold{34}(1), 118--129
}
\seealso{
\code{\link{ss.data.wbx}}
}
\keyword{datasets}
