% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate-effect-sizes.R
\name{batch_calc_ES}
\alias{batch_calc_ES}
\title{Calculate effect sizes from a dataset for multiple series}
\usage{
batch_calc_ES(
  dat,
  grouping,
  condition,
  outcome,
  aggregate = NULL,
  weighting = "equal",
  session_number = NULL,
  baseline_phase = NULL,
  intervention_phase = NULL,
  ES = c("LRRd", "LRRi", "SMD", "Tau"),
  improvement = "increase",
  scale = "other",
  intervals = NA,
  observation_length = NA,
  confidence = 0.95,
  format = "long",
  warn = TRUE,
  ...
)
}
\arguments{
\item{dat}{data frame containing SCD series for which effect sizes will be
calculated.}

\item{grouping}{A variable name or list of (unquoted) variable names that
uniquely identify each data series.}

\item{condition}{A variable name that identifies the treatment condition for
each observation in the series.}

\item{outcome}{A variable name for the outcome data. Default is}

\item{aggregate}{A variable name of list of (unquoted) variable names that
identify additional grouping variables. Effect sizes will be calculated
separately for each unique value of these variables, after which the effect
size estimates will be averaged across values of these variables (but not
across the values of the \code{grouping} variables).}

\item{weighting}{character string specifying the weighting scheme for use
when variables are specified in \code{aggregate}. Available is
\code{"1/V"}, \code{"equal"} (the default), \code{"Equal"}, \code{"nA"},
\code{"n_A"}, \code{"nB"}, \code{"n_B"}, \code{"nAnB"}, \code{"nA*nB"},
\code{"nA*nB"}, \code{"n_A*n_B"}, \code{"n_A * n_B"}, \code{"1/nA+1/nB"},
\code{"1/nA + 1/nB"}, \code{"1/n_A+1/n_B"}, or \code{"1/n_A + 1/n_B"}. Note
that \code{"1/V"} can only be used for effect sizes with known standard
errors.}

\item{session_number}{A variable name used to order the data within each
series.}

\item{baseline_phase}{character string specifying which value of
\code{condition} corresponds to the baseline phase. If \code{NULL} (the
default), the first observed value of \code{condition} within the series
will be used.}

\item{intervention_phase}{character string specifying which value of
\code{condition} corresponds to the intervention phase. If \code{NULL} (the
default), the second unique value of \code{condition} within the series
will be used.}

\item{ES}{character string or character vector specifying which effect size
index or indices to calculate. Available effect sizes are \code{"LRRd"},
\code{"LRRi"}, \code{"LRM"}, \code{"LOR"}, \code{"SMD"}, \code{"NAP"},
\code{"IRD"}, \code{"PND"}, \code{"PEM"}, \code{"PAND"}, \code{"Tau"},
\code{"Tau-U"}, and \code{"Tau-BC"}. Set to \code{"all"} for all available
effect sizes. Set to \code{"parametric"} for all parametric effect sizes.
Set to \code{"NOM"} for all non-overlap measures. Defaults to calculating
the LRRd, LRRi, SMD, and Tau indices.}

\item{improvement}{character string either indicating the direction of
uniform improvement ("increase" or "decrease") or the variable name of a
variable identifying the direction of improvement for each series. Default
is "increase".}

\item{scale}{character string indicating the common scale of the outcome
variable across all of the series in the data set or the name of a variable
within the dataset that identifies the outcome scale within each series.
Possible values for the scale are \code{"percentage"} for a percentage with
range 0-100, \code{"proportion"} for a proportion with range 0-1,
\code{"count"} for a frequency count (0 or positive integers),
\code{"rate"} for a standardized rate per minute. If a vector, the most
frequent unique value will be used and missing values will be ignored.
Defaults to \code{NA}.}

\item{intervals}{for interval recording procedures. Either the total number
of intervals per observation session common to all series in the dataset,
or the name of a variable within the dataset that identifies the number of
intervals for each observation. If a variable name, the mean number of
intervals within each series will be used. Missing values will be ignored.
Defaults to \code{NA}.}

\item{observation_length}{Used for the log-response ratio. Either the common
observation session length (in minutes) across all series in the dataset or
a variable name containing the observation session length for each
observation. If a variable name, the mean observation session length within
each series will be used. Missing values will be ignored. Defaults to
\code{NA}.}

\item{confidence}{confidence level for the reported interval estimate. Set to
\code{NULL} to omit confidence interval calculations.}

\item{format}{character string specifying whether to organize the results in
\code{"long"} format or \code{"wide"} format. Defaults to \code{"long"}.}

\item{warn}{logical indicating whether warnings should be displayed. Default
is \code{TRUE}.}

\item{...}{further arguments used for calculating some of the effect size
indices.}
}
\value{
A tibble containing the estimate, standard error, and/or confidence
  interval for each specified effect size.
}
\description{
Calculates one or more effect size estimates, along with
  associated standard errors and confidence intervals, if available, for a
  single-case data series.
}
\details{
Calculates one or more effect size indices for each series in a
  dataset
}
\examples{

data(McKissick)
batch_calc_ES(McKissick,
              grouping = Case_pseudonym,
              condition = Condition,
              outcome = Outcome,
              ES = c("LRRd","LRRi"),
              improvement = "decrease",
              scale = "count",
              observation_length = 20,
              format = "long")

data(Schmidt2007)
batch_calc_ES(dat = Schmidt2007,
              grouping = c(Behavior_type, Case_pseudonym, Phase_num),
              condition = Condition,
              outcome = Outcome,
              ES = c("LRRi","LRRd"),
              improvement = direction,
              scale = Metric,
              bias_correct = TRUE,
              confidence = NULL,
              format = "wide")

# Aggregate across phase-pairs
batch_calc_ES(dat = Schmidt2007,
              grouping = c(Behavior_type, Case_pseudonym),
              aggregate = Phase_num,
              weighting = "1/V",
              condition = Condition,
              outcome = Outcome,
              ES = c("LRRi", "LRRd", "SMD", "Tau"),
              improvement = direction,
              scale = "count",
              bias_correct = TRUE,
              confidence = NULL,
              format = "long")

}
