% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non-overlap-measures.R
\name{PND}
\alias{PND}
\title{Percentage of non-overlapping data}
\usage{
PND(A_data, B_data, condition, outcome, baseline_phase = unique(condition)[1],
  improvement = "increase")
}
\arguments{
\item{A_data}{vector of numeric data for A phase. Missing values are dropped.}

\item{B_data}{vector of numeric data for B phase. Missing values are dropped.}

\item{condition}{vector identifying the treatment condition for each
observation in the series.}

\item{outcome}{vector of outcome data for the entire series.}

\item{baseline_phase}{character string specifying which value of
\code{condition} corresponds to the baseline phase. Defaults to first
observed value of \code{condition}.}

\item{improvement}{character string indicating direction of improvement.
Default is "increase".}
}
\value{
Numeric value
}
\description{
Calculates the percentage of non-overlapping data index 
  (Scruggs, Mastropieri, & Castro, 1987).
}
\details{
For an outcome where increase is desirable, PND is calculated as the
  proportion of observations in the B phase that exceed the highest 
  observation from the A phase. For an outcome where decrease is desirable, 
  PND is the proportion of observations in the B phase that are less than the
  lowest observation from the A phase. The range of PND is [0,1].
}
\examples{
A <- c(20, 20, 26, 25, 22, 23)
B <- c(28, 25, 24, 27, 30, 30, 29)
PND(A_data = A, B_data = B)

}
\references{
Scruggs, T. E., Mastropieri, M. A., & Casto, G. (1987). The 
  quantitative synthesis of single-subject research: Methodology and 
  validation. \emph{Remedial and Special Education, 8}(2), 24--43. 
  doi:\href{http://dx.doi.org/10.1177/074193258700800206}{10.1177/074193258700800206}
}
