% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_stats.R
\name{pairwise_stats}
\alias{pairwise_stats}
\title{Calculate pairwise statistics between groups}
\usage{
pairwise_stats(
  x,
  group_cols,
  var_cols,
  fxn,
  two_way = FALSE,
  output_format = "v1",
  ...
)
}
\arguments{
\item{x}{A data.frame or tibble.}

\item{group_cols}{Vector of the names of the grouping columns.}

\item{var_cols}{Vector of the names of the variables of interest.}

\item{fxn}{The function to be applied.}

\item{two_way}{Whether the order of data inputs to fxn matter.}

\item{output_format}{The version of the output format (v0 or v1).}

\item{...}{Extra arguments passed to fxn, i.e. alternative = "greater", etc.}
}
\value{
A tibble.

A pairwise_stats object with slots for the results, grouping 
variables, variable of interest, and any other parameters passed in, 
excluding the input data frame.
}
\description{
pairwise_stats performs a provided function pairwise between 
all combinations of groups. The first two arguments of the function passed 
to pairwise_stats must accept vectors of values as inputs. These vectors 
should correspond to the values for group A and group B, respectively.

The function takes as input a data.frame or tibble, the column names of 
grouping variables, the column name for a variable of interest, and a 
function.
}
\examples{
pairwise_stats(iris, "Species", "Sepal.Length", t.test)
}
