% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory.R
\name{trajectory,SimInf_pfilter-method}
\alias{trajectory,SimInf_pfilter-method}
\title{Extract filtered trajectory from running a particle filter}
\usage{
\S4method{trajectory}{SimInf_pfilter}(model, compartments, index, format = c("data.frame", "matrix"))
}
\arguments{
\item{model}{the \code{SimInf_pfilter} object to extract the
result from.}

\item{compartments}{specify the names of the compartments to
extract data from. The compartments can be specified as a
character vector e.g. \code{compartments = c('S', 'I', 'R')},
or as a formula e.g. \code{compartments = ~S+I+R} (see
\sQuote{Examples}). Default (\code{compartments=NULL}) is to
extract the number of individuals in each compartment i.e. the
data from all discrete state compartments in the model. In
models that also have continuous state variables e.g. the
\code{SISe} model, they are also included.}

\item{index}{indices specifying the subset of nodes to include
when extracting data. Default (\code{index = NULL}) is to
extract data from all nodes.}

\item{format}{the default (\code{format = "data.frame"}) is to
generate a \code{data.frame} with one row per node and
time-step with the number of individuals in each
compartment. Using \code{format = "matrix"} returns the result
as a matrix, which is the internal format (see
\sQuote{Details} in
\code{\link{trajectory,SimInf_model-method}}).}
}
\value{
A \code{data.frame} if \code{format = "data.frame"}, else
    a matrix.
}
\description{
Extract filtered trajectory from running a particle filter
}
