## This file is part of SimInf, a framework for stochastic
## disease spread simulations.
##
## Copyright (C) 2015 -- 2022 Stefan Widgren
##
## SimInf is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## SimInf is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program.  If not, see <https://www.gnu.org/licenses/>.

library(SimInf)

## Define a tolerance
tol <- 1e-8

##
## Generate proposals without particles from the previous generation.
##

proposals_exp <- matrix(c(0.788305135443807,    0.4089769218117,
                          0.883017404004931,    0.940467284293845,
                          0.0455564993899316,   0.528105488047004,
                          0.892419044394046,    0.551435014465824,
                          0.456614735303447,    0.956833345349878,
                          0.453334156190977,    0.677570635452867,
                          0.572633401956409,    0.102924682665616,
                          0.899824970401824,    0.24608773435466,
                          0.0420595335308462,   0.327920719282702,
                          0.954503649147227,    0.889539316063747,
                          0.6928034061566,      0.640506813768297,
                          0.994269776623696,    0.655705799115822,
                          0.708530468167737,    0.544066024711356,
                          0.59414202044718,     0.28915973729454,
                          0.147113647311926,    0.963024232536554,
                          0.902299045119435,    0.690705278422683,
                          0.795467417687178,    0.0246136845089495,
                          0.477795971091837,    0.758459537522867,
                          0.216407935833558,    0.318181007634848,
                          0.231625785352662,    0.142800022382289,
                          0.414546335814521,    0.413724326295778,
                          0.368845450924709,    0.152444747742265,
                          0.13880606344901,     0.233034099452198,
                          0.465962450252846,    0.265972640365362,
                          0.857827715342864,    0.0458311666734517,
                          0.442200074205175,    0.798924845643342,
                          0.12189925997518,     0.560947983758524,
                          0.20653138961643,     0.127531650243327,
                          0.753307864302769,    0.895045359153301,
                          0.374462775886059,    0.665115194628015,
                          0.0948406609240919,   0.383969637798145,
                          0.27438364457339,     0.814640038879588,
                          0.448516341391951,    0.810064353048801,
                          0.812389509519562,    0.794342321110889,
                          0.439831687603146,    0.754475158639252,
                          0.629221131559461,    0.710182401351631,
                          0.000624773325398564, 0.475316574098542,
                          0.220118885161355,    0.379816537722945,
                          0.612771003274247,    0.351797909243032,
                          0.111135424347594,    0.243619472719729,
                          0.66805558744818,     0.417646779678762,
                          0.788195834029466,    0.102864644257352,
                          0.434892741497606,    0.984956979984418,
                          0.893051114398986,    0.886469060787931,
                          0.175052650272846,    0.130695691565052,
                          0.653101925039664,    0.343516472261399,
                          0.656758127966896,    0.320373242488131,
                          0.187691119266674,    0.782294301316142,
                          0.0935949867125601,   0.46677904156968,
                          0.511505459900945,    0.59998895926401,
                          0.332823540316895,    0.488613033667207,
                          0.954473827499896,    0.4829023971688,
                          0.890350222121924,    0.914438186911866,
                          0.608734982321039,    0.410689776530489,
                          0.147094690939412,    0.935299803270027,
                          0.301228899974376,    0.0607205715496093,
                          0.947726940037683,    0.720596273429692,
                          0.142294295597821,    0.549284656066447,
                          0.95409123855643,     0.585483353119344,
                          0.404510281747207,    0.64789347932674,
                          0.319820617092773,    0.307720010867342,
                          0.219767631264403,    0.369488865835592,
                          0.984219203470275,    0.154202300822362,
                          0.0910439998842776,   0.141906907781959,
                          0.690007101511583,    0.619256483390927,
                          0.891394117148593,    0.672999092610553,
                          0.737077737925574,    0.521135725779459,
                          0.65983844967559,     0.821805460145697,
                          0.786281551700085,    0.979821917368099,
                          0.439431536244228,    0.31170220207423,
                          0.409474952612072,    0.0104671118315309,
                          0.18384952400811,     0.842729318886995,
                          0.231161782052368,    0.239099955651909,
                          0.0766911653336138,   0.245723678031936,
                          0.73213520552963,     0.847453165100887,
                          0.497527267085388,    0.387909029843286,
                          0.246448994148523,    0.111096461303532,
                          0.389994435245171,    0.571935313986614,
                          0.216892762808129,    0.44476800202392,
                          0.21799066872336,     0.502299563260749,
                          0.353904571849853,    0.64998515881598,
                          0.374713956611231,    0.355445380788296,
                          0.533687945455313,    0.740334360394627,
                          0.221102937823161,    0.41274611861445,
                          0.265686686849222,    0.629973053466529,
                          0.183828490786254,    0.86364411143586,
                          0.746568004135042,    0.668284649727866,
                          0.618017873261124,    0.372238060226664,
                          0.529835685854778,    0.874682342866436,
                          0.581750099780038,    0.839767764788121,
                          0.312448164913803,    0.70829032221809,
                          0.265017806086689,    0.594343194039539,
                          0.481289800489321,    0.26503273146227,
                          0.564590434776619,    0.913188223028556,
                          0.901874389499426,    0.274166621500626,
                          0.321482756407931,    0.985640884377062,
                          0.619993310188875,    0.937314089154825,
                          0.466532702324912,    0.406832593260333,
                          0.659230324206874,    0.152346616843715,
                          0.572867058217525,    0.238726026844233),
                        nrow = 100, ncol = 2, byrow = TRUE,
                        dimnames = list(NULL, c("beta", "gamma")))

attr(proposals_exp, "ancestor") <- rep(NA_integer_, 100)

set.seed(123)
proposals_obs <-
    .Call(SimInf:::SimInf_abc_proposals, ## function
          c("beta", "gamma"),            ## parameter
          c("uniform", "uniform"),       ## distribution
          c(0, 0),                       ## p1
          c(1, 1),                       ## p2
          100L,                          ## n
          NULL,                          ## x
          NULL,                          ## w
          NULL)                          ## sigma

stopifnot(identical(dim(proposals_obs), dim(proposals_exp)))
stopifnot(identical(dimnames(proposals_obs), dimnames(proposals_exp)))
stopifnot(all(abs(proposals_obs - proposals_exp) < tol))
stopifnot(identical(attr(proposals_obs, "ancestor"),
                    attr(proposals_exp, "ancestor")))

##
## Determine weights for the proposals
##

w_exp <- rep(0.01, 100)

w_obs <- .Call(SimInf:::SimInf_abc_weights, ## function
               c("uniform", "uniform"),     ## distribution
               c(0, 0),                     ## p1
               c(1, 1),                     ## p2
               NULL,                        ## x
               proposals_obs,               ## xx
               NULL,                        ## w
               NULL)                        ## sigma

stopifnot(identical(length(w_obs), length(w_exp)))
stopifnot(all(abs(w_obs - w_exp) < tol))

##
## Generate proposals with particles from a previous generation.
##

proposals_exp <- matrix(c(0.40449021397453,    0.209258724620122,
                          0.36482482505885,    0.177208382897285,
                          0.110673292350425,   0.0794986914792483,
                          0.187167868494588,   0.138234511613991,
                          0.0129193391123231,  0.0535672393807684,
                          0.371875050064337,   0.134845566874378,
                          0.247248031392758,   0.126673609970299,
                          0.183642149340511,   0.0731331396573393,
                          0.20911740588746,    0.0948903274398692,
                          0.262342094567642,   0.125179104685734,
                          0.177528318171729,   0.0741054597654854,
                          0.156151696536369,   0.090429058755398,
                          0.2878964747592,     0.144758670272637,
                          0.115570346272429,   0.096959225400175,
                          0.35527286855174,    0.161557776257793,
                          0.0650153072101651,  0.00255140678233257,
                          0.372258330220992,   0.133720658379678,
                          0.402004557396214,   0.190127049086695,
                          0.288281903108544,   0.150967395091388,
                          0.177909054629067,   0.0998662267148997,
                          0.336508383404385,   0.193255960409785,
                          0.493830751357006,   0.235285023981504,
                          0.150045602591045,   0.0978408919339508,
                          0.0991368666223921,  0.114314801264312,
                          0.218399403384471,   0.0989904109886274,
                          0.185099330012481,   0.0892108392300413,
                          0.161944605578993,   0.0604990966997036,
                          0.222789306144925,   0.151835826025647,
                          0.065428159161678,   0.0629737938634062,
                          0.23615906645682,    0.102537558499362,
                          0.0121276214604985,  0.0628933335766671,
                          0.201775823307792,   0.126217268774852,
                          0.137263474185558,   0.112391434285224,
                          0.264624142608849,   0.169454608095463,
                          0.312728091948025,   0.0963945630588326,
                          0.175526458577421,   0.0686229881214495,
                          0.0593637021715585,  0.0522592803469739,
                          0.215230839090112,   0.155696377876435,
                          0.0529094844818739,  0.0320773020404419,
                          0.33619295761988,    0.179355314279367,
                          0.181477854077582,   0.10047336472656,
                          0.21069018904093,    0.14241445146947,
                          0.139211751314129,   0.0689293727497798,
                          0.352694196052565,   0.16279166759017,
                          0.226482666581105,   0.126181747015655,
                          0.269213756712608,   0.134008000696826,
                          0.0819893183892228,  0.0804205926286409,
                          0.316344402602474,   0.141277619454973,
                          0.0415392652110742,  0.064295265585175,
                          0.0578856463374477,  0.087630895538036,
                          0.200832741112366,   0.096648847157614,
                          0.148811803643498,   0.0750742362153645,
                          0.191379030672455,   0.115737154467271,
                          0.161899095545659,   0.0750730031877879,
                          0.309156788420073,   0.168264661165334,
                          0.0859624973882138,  0.030587660584528,
                          0.0603779474270183,  0.0454745455018321,
                          0.350172184371153,   0.176682327720304,
                          0.122998229064858,   0.0882698562573068,
                          0.241334749076453,   0.147564901163679,
                          0.0766590044181838,  0.0434986125841068,
                          0.348278201059334,   0.191013869028047,
                          0.257268077430999,   0.179321515928957,
                          0.223064948567959,   0.0592622522014079,
                          0.427815559979751,   0.175047967508291,
                          0.235672458510888,   0.121165312322979,
                          0.167714899755654,   0.0903647430326278,
                          0.0915963546018915,  0.0651409817705193,
                          0.218331597808469,   0.104343950311149,
                          0.280915332879878,   0.126599331161323,
                          0.106748273493958,   0.0870869332381226,
                          0.267450910188283,   0.165256775670049,
                          0.0903771196756504,  0.0498756856503441,
                          0.258634833807708,   0.134139700799639,
                          0.0295659758705841,  0.0775270276812072,
                          0.227391392219538,   0.0816484593169099,
                          0.130314347249228,   0.029628912819613,
                          0.159126993527458,   0.0856407681638652,
                          0.290396981413321,   0.143042180482158,
                          0.0373833335256739,  0.0680495387444054,
                          0.302136009179183,   0.161372082543716,
                          0.442464566486759,   0.197717305508349,
                          0.220956904210761,   0.132325899715497,
                          0.383435091126591,   0.189195961844464,
                          0.00381862106974051, 0.0320324001946579,
                          0.193629157284585,   0.131457415291685,
                          0.124570282588458,   0.114510381022667,
                          0.247574724494243,   0.146305479285253,
                          0.135945749855924,   0.0830472764106766,
                          0.221986437891198,   0.161642051632531,
                          0.101839500171702,   0.0763136426325731,
                          0.145580556982575,   0.0920176018942565,
                          0.0931858029996674,  0.0538420972542555,
                          0.224730087525381,   0.105317389453258,
                          0.225838257380999,   0.133549398107083,
                          0.306352939853714,   0.188866355047975,
                          0.247124496788588,   0.125364413806328,
                          0.21457415007365,    0.0886153625185365,
                          0.234312573547032,   0.101556928688184,
                          0.352387419464283,   0.16910808806427),
                        nrow = 100, ncol = 2, byrow = TRUE,
                        dimnames = list(NULL, c("beta", "gamma")))

attr(proposals_exp, "ancestor") <-
    c(6L, 3L, 9L, 9L, 2L, 6L, 9L, 6L, 3L, 9L, 3L, 6L, 6L, 2L, 9L, 3L,
      3L, 9L, 9L, 6L, 6L, 9L, 6L, 6L, 6L, 6L, 3L, 2L, 9L, 9L, 6L, 6L,
      2L, 3L, 3L, 3L, 3L, 2L, 3L, 3L, 3L, 2L, 3L, 3L, 3L, 9L, 2L, 3L,
      6L, 2L, 6L, 3L, 2L, 6L, 3L, 6L, 2L, 3L, 3L, 9L, 3L, 9L, 9L, 6L,
      3L, 6L, 6L, 6L, 2L, 3L, 3L, 3L, 6L, 3L, 2L, 3L, 6L, 3L, 6L, 2L,
      3L, 9L, 9L, 9L, 2L, 2L, 6L, 3L, 6L, 3L, 2L, 6L, 2L, 3L, 6L, 6L,
      3L, 3L, 9L, 3L)

sigma <- matrix(c(0.0111588476485889,  0.00441287501075721,
                  0.00441287501075721, 0.00237388735640902),
                nrow = 2, ncol = 2, byrow = TRUE,
                dimnames = list(c("beta", "gamma"), c("beta", "gamma")))

w <- c(0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1)

x <- matrix(c(0.100721582304686,  0.0719040972180665,
              0.120237128576264,  0.0883633010089397,
              0.241502250079066,  0.118690322386101,
              0.196719169151038,  0.111476795747876,
              0.0473383399657905, 0.0265292769763619,
              0.142388037405908,  0.0744408417958766,
              0.118218665011227,  0.103439392056316,
              0.246003416366875,  0.0970179655123502,
              0.277967476984486,  0.150379287777469,
              0.126839369302616, 0.0596327660605311),
            nrow = 10, ncol = 2, byrow = TRUE,
            dimnames = list(NULL, c("beta", "gamma")))

set.seed(123)
proposals_obs <-
    .Call(SimInf:::SimInf_abc_proposals, ## function
          c("beta", "gamma"),            ## parameter
          c("uniform", "uniform"),       ## distribution
          c(0, 0),                       ## p1
          c(1, 1),                       ## p2
          100L,                          ## n
          x,                             ## x
          w,                             ## w
          sigma)                         ## sigma

stopifnot(identical(dim(proposals_obs), dim(proposals_exp)))
stopifnot(identical(dimnames(proposals_obs), dimnames(proposals_exp)))
stopifnot(all(abs(proposals_obs - proposals_exp) < tol))
stopifnot(identical(attr(proposals_obs, "ancestor"),
                    attr(proposals_exp, "ancestor")))

##
## Determine particle weights with particles from a previous
## generation.
##

w <- c(0.0887036508782177, 0.166359113528729, 0.0837072024175504,
       0.0744001632010883, 0.135889593166249, 0.0855856292642815,
       0.0982428712389774, 0.108701885332761, 0.0751630561589793,
       0.0832468348131658)

sigma <- matrix(c(0.00492214698840636, 0.00214848981388495,
                  0.00214848981388495, 0.00148131946857759),
                nrow = 2, ncol = 2, byrow = TRUE,
                dimnames = list(c("beta", "gamma"), c("beta", "gamma")))

x <- matrix(c(0.181656674010934, 0.088313908707635,
              0.13237129296898,  0.0653391855550409,
              0.13237129296898,  0.0653391855550409,
              0.13237129296898,  0.0653391855550409,
              0.164534995786719, 0.102338963629853,
              0.253254773828567, 0.0945404905257672,
              0.164534995786719, 0.102338963629853,
              0.181656674010934, 0.088313908707635,
              0.164534995786719, 0.102338963629853,
              0.253254773828567, 0.0945404905257672),
            nrow = 10, ncol = 2, byrow = TRUE,
            dimnames = list(NULL, c("beta", "gamma")))

xx <- matrix(c(0.207941308990465,  0.110336421309656,
               0.123214899415275,  0.0707943094184964,
               0.106876498007091,  0.0521419601364841,
               0.0817667562688388, 0.0384318357782007,
               0.13190369503059,   0.0784629457261605,
               0.231164237650949,  0.0977418120716123,
               0.187665128906516,  0.0899812114257998,
               0.17464412045458,   0.0826845340300653,
               0.178604586453451,  0.120632356669452,
               0.208363762292826, 0.105931947092043),
             nrow = 10, ncol = 2, byrow = TRUE,
             dimnames = list(NULL, c("beta", "gamma")))

w_exp <- c(0.0923963866851073, 0.0836785669165191, 0.100309975935471,
           0.139249040595048, 0.08154757535186, 0.122518476357057,
           0.0807798908697413, 0.0785544941015971, 0.13056926565214,
           0.0903963275354594)

w_obs <- .Call(SimInf:::SimInf_abc_weights, ## function
               c("uniform", "uniform"),     ## distribution
               c(0, 0),                     ## p1
               c(1, 1),                     ## p2
               x,                           ## x
               xx,                          ## xx
               w,                           ## w
               sigma)                       ## sigma

stopifnot(identical(length(w_obs), length(w_exp)))
stopifnot(all(abs(w_obs - w_exp) < tol))
