% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc.R
\docType{class}
\name{SimInf_abc-class}
\alias{SimInf_abc-class}
\title{Class \code{"SimInf_abc"}}
\description{
Class \code{"SimInf_abc"}
}
\section{Slots}{

\describe{
\item{\code{model}}{The \code{SimInf_model} object to estimate parameters
in.}

\item{\code{priors}}{A \code{data.frame} containing the four columns
\code{parameter}, \code{distribution}, \code{p1} and
\code{p2}. The column \code{parameter} gives the name of the
parameter referred to in the model. The column
\code{distribution} contains the name of the prior
distribution. Valid distributions are 'gamma', 'normal' or
'uniform'. The column \code{p1} is a numeric vector with the
first hyperparameter for each prior: 'gamma') shape, 'normal')
mean, and 'uniform') lower bound. The column \code{p2} is a
numeric vector with the second hyperparameter for each prior:
'gamma') rate, 'normal') standard deviation, and 'uniform')
upper bound.}

\item{\code{target}}{Character vector (\code{gdata} or \code{ldata}) that
determines if the ABC-SMC method estimates parameters in
\code{model@gdata} or in \code{model@ldata}.}

\item{\code{pars}}{Index to the parameters in \code{target}.}

\item{\code{npart}}{The number of particles in each generation.}

\item{\code{nprop}}{An integer vector with the number of simulated
proposals in each generation.}

\item{\code{fn}}{A function for calculating the summary statistics for the
simulated trajectory and determine for each particle if it
should be accepted (\code{TRUE}) or rejected (\code{FALSE}).
The first argument in \code{fn} is the simulated model
containing one trajectory.  The second argument to \code{fn}
is an integer with the \code{generation} of the particles.
The function should return a logical vector with one value for
each particle in the simulated model.}

\item{\code{epsilon}}{A numeric matrix (number of summary statistics X
number of generations) where each column contains the
tolerances for a generation and each row contains a sequence
of gradually decreasing tolerances.}

\item{\code{x}}{A list where each item is a \code{matrix} with the
accepted particles in each generation. Each column is one
particle.}

\item{\code{w}}{A list where each item is a vector with the weights for
the particles \code{x} in the corresponding generation.}

\item{\code{ess}}{A numeric vector with the effective sample size (ESS) in
each generation. Effective sample size is computed as
\deqn{\left(\sum_{i=1}^N\!(w_{g}^{(i)})^2\right)^{-1},}{1 /
(sum(w_ig^2)),} where \eqn{w_{g}^{(i)}}{w_ig} is the
normalized weight of particle \eqn{i} in generation \eqn{g}.}
}}

\seealso{
\code{\link{abc}} and \code{\link{continue}}.
}
