% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_model.R
\docType{methods}
\name{run}
\alias{run}
\alias{run,SimInf_model-method}
\title{Run the SimInf stochastic simulation algorithm}
\usage{
run(model, threads = NULL, solver = c("ssm", "aem"))

\S4method{run}{SimInf_model}(model, threads = NULL, solver = c("ssm",
  "aem"))
}
\arguments{
\item{model}{The siminf model to run.}

\item{threads}{Number of threads. Default is NULL, i.e. to use all
available processors.}

\item{solver}{Which numerical solver to utilize. Default is 'ssm'.}
}
\value{
\code{SimInf_model} with result from simulation.
}
\description{
Run the SimInf stochastic simulation algorithm
}
\examples{
## Create an 'SIR' model with 10 nodes and initialise
## it to run over 100 days.
model <- SIR(u0 = data.frame(S = rep(99, 10),
                             I = rep(1, 10),
                             R = rep(0, 10)),
             tspan = 1:100,
             beta = 0.16,
             gamma = 0.077)

## Run the model and save the result.
result <- run(model, threads = 1)

## Plot the proportion of susceptible, infected and recovered
## individuals.
plot(result)
}
\references{
\itemize{
  \item Bauer P, Engblom S, Widgren S
  (2016) "Fast Event-Based Epidemiological Simulations on National Scales"
  International Journal of High Performance Computing
  Applications, 30(4), 438-453. doi:10.1177/1094342016635723

  \item Bauer P., Engblom S. (2015) Sensitivity Estimation and
  Inverse Problems in Spatial Stochastic Models of Chemical
  Kinetics. In: Abdulle A., Deparis S., Kressner D., Nobile F.,
  Picasso M. (eds) Numerical Mathematics and Advanced Applications
  - ENUMATH 2013. Lecture Notes in Computational Science and
  Engineering, vol 103. Springer, Cham. Doi:
  10.1007/978-3-319-10705-9_51
}
}
