% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Design.R
\name{createDesign}
\alias{createDesign}
\alias{print.Design}
\title{Create the simulation Design object}
\usage{
createDesign(..., subset, tibble = TRUE, stringsAsFactors = FALSE)

\method{print}{Design}(x, list2char = TRUE, ...)
}
\arguments{
\item{...}{comma separated list of named input objects representing the simulation
factors to completely cross. Note that these arguments are passed to
\code{\link{expand.grid}} to perform the complete crossings}

\item{subset}{(optional) a logical vector indicating elements or rows to keep
to create a partially crossed simulation design}

\item{tibble}{logical; return a \code{tibble} object instead of a
\code{data.frame}? Default is TRUE}

\item{stringsAsFactors}{logical; should character variable inputs be coerced
to factors when building a \code{data.frame}? Default is FALSE}

\item{x}{object returned by \code{\link{createDesign}}}

\item{list2char}{logical; for \code{tibble} object re-evaluate list elements
as character vectors for better printing of the levels? Note that this
does not change the original classes of the object, just how they are printed.
Default is TRUE}
}
\value{
a \code{tibble} or \code{data.frame} containing the simulation experiment
  conditions to be evaluated in \code{\link{runSimulation}}
}
\description{
Create a partially or fully-crossed data object reflecting the unique
simulation design conditions. Each row of the returned object represents
a unique simulation condition, and each column represents the named factor
variables under study.
}
\examples{
\dontrun{

# modified example from runSimulation()

Design <- createDesign(N = c(10, 20),
                       SD = c(1, 2))
Design

# remove N=10, SD=2 row from initial definition
Design <- createDesign(N = c(10, 20),
                       SD = c(1, 2),
                       subset = !(N == 10 & SD == 2))
Design

# example with list inputs
Design <- createDesign(N = c(10, 20),
                       SD = c(1, 2),
                       combo = list(c(0,0), c(0,0,1)))
Design   # notice levels printed (not typical for tibble)
print(Design, list2char = FALSE)   # standard tibble output

Design <- createDesign(N = c(10, 20),
                       SD = c(1, 2),
                       combo = list(c(0,0), c(0,0,1)),
                       combo2 = list(c(5,10,5), c(6,7)))
Design
print(Design, list2char = FALSE)   # standard tibble output

}
}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
