% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{RSE}
\alias{RSE}
\title{Compute the relative standard error ratio}
\usage{
RSE(SE, ests, unname = FALSE)
}
\arguments{
\item{SE}{a \code{numeric} matrix of SE estimates across the replications (extracted
from the \code{results} object in the Summarise step). Alternatively, can be a vector containing
the mean of the SE estimates across the R simulation replications}

\item{ests}{a \code{numeric} matrix object containing the parameter estimates under investigation
found within the \code{\link{Summarise}} function. This input is used to compute the
standard deviation/variance estimates for each column to evaluate how well the expected SE
matches the standard deviation}

\item{unname}{logical; apply \code{\link{unname}} to the results to remove any variable
names?}
}
\value{
returns vector of variance ratios, (RSV = SE^2/SD^2)
}
\description{
Computes the relative standard error ratio given the set of estimated standard errors (SE) and the
deviation across the R simulation replications (SD). The ratio is formed by finding the expectation
of the SE terms, and compares this expectation to the general variability of their respective parameter
estimates across the R replications (ratio should equal 1). This is used to roughly evaluate whether the
SEs being advertised by a given estimation method matches the sampling variability of the respective
estimates across samples.
}
\examples{

R <- 10000
par_ests <- cbind(rnorm(R), rnorm(R, sd=1/10),
                  rnorm(R, sd=1/15))
colnames(par_ests) <- paste0("par", 1:3)
(SDs <- apply(par_ests, 2, sd))

SEs <- cbind(1 + rnorm(R, sd=.01),
             1/10 + + rnorm(R, sd=.01),
             1/15 + rnorm(R, sd=.01))
(E_SEs <- colMeans(SEs))
RSE(SEs, par_ests)

# equivalent to the form
colMeans(SEs) / (SDs)


}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
