% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{Generate}
\alias{Generate}
\title{Generate data}
\usage{
Generate(condition, fixed_objects = NULL)
}
\arguments{
\item{condition}{a single row from the \code{design} input (as a \code{data.frame}), indicating the
simulation conditions}

\item{fixed_objects}{object passed down from \code{\link{runSimulation}}}
}
\value{
returns a single object containing the data to be analyzed (usually a
  \code{vector}, \code{matrix}, or \code{data.frame}),
  or \code{list}
}
\description{
Generate data from a single row in the \code{design} input (see \code{\link{runSimulation}}). R contains
numerous approaches to generate data, some of which are contained in the base package, as well
as in \code{SimDesign} (e.g., \code{\link{rmgh}}, \code{\link{rValeMaurelli}}, \code{\link{rHeadrick}}).
However the majority can be found in external packages. See CRAN's list of possible distributions here:
\url{https://CRAN.R-project.org/view=Distributions}
}
\examples{
\dontrun{

mygenerate <- function(condition, fixed_objects = NULL){
    N1 <- condition$sample_sizes_group1
    N2 <- condition$sample_sizes_group2
    sd <- condition$standard_deviations

    group1 <- rnorm(N1)
    group2 <- rnorm(N2, sd=sd)
    dat <- data.frame(group = c(rep('g1', N1), rep('g2', N2)),
                      DV = c(group1, group2))
    # just a silly example of a simulated parameter
    pars <- list(random_number = rnorm(1))

    list(dat=dat, parameters=pars)
}

# similar to above, but using the Attach() function instead of indexing
mygenerate <- function(condition, fixed_objects = NULL){
    Attach(condition)
    N1 <- sample_sizes_group1
    N2 <- sample_sizes_group2
    sd <- standard_deviations

    group1 <- rnorm(N1)
    group2 <- rnorm(N2, sd=sd)
    dat <- data.frame(group = c(rep('g1', N1), rep('g2', N2)),
                      DV = c(group1, group2))
    dat
}

mygenerate2 <- function(condition, fixed_objects = NULL){
    mu <- sample(c(-1,0,1), 1)
    dat <- rnorm(100, mu)
    dat        #return simple vector (discard mu information)
}

mygenerate3 <- function(condition, fixed_objects = NULL){
    mu <- sample(c(-1,0,1), 1)
    dat <- data.frame(DV = rnorm(100, mu))
    dat
}

}

}
\seealso{
\code{\link{add_missing}}, \code{\link{Attach}},
  \code{\link{rmgh}}, \code{\link{rValeMaurelli}}, \code{\link{rHeadrick}}
}
