% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NewMEVGumbelCopula.R
\name{NewMEVGumbelCopula}
\alias{NewMEVGumbelCopula}
\title{Creates a Gumpel copula}
\usage{
NewMEVGumbelCopula(r = 2)
}
\arguments{
\item{r}{real, the parameter of the Gumbel copula, defaults to 2, must be larger or equal to one.}
}
\value{
A function that evaluates the Gumbel copula (with parameter r) at a given \eqn{d}-dimensional vector in the unit cube.  The environment of the function also contains a function called \code{pdfCopula} that evaluates the probability density function of the Gumbel copula via automatic differentation.
}
\description{
Creates an instance of the Gumbel copula with parameter r.  This family is also known as the Gumbel--Hougaard copula or the logistic model.
}
\details{
The following parameterisation of the copula is used:
\deqn{C(u_1,\dots,u_d) = \exp\left(- \left\{ \sum_{j=1}^d \bar u_j^r \right\}^{1/r}\right)}{C(u_1,\dots,u_d) = exp(- { \sum_j v_j^r }^{1/r} )}
where \eqn{\bar u_j = -\log(u_j)}{v_j = -log(u_j)}, \eqn{j=1,\dots,d}.
}
\seealso{
\code{\link{NewMEVAsyLogisticCopula}}
}
\author{
Berwin A. Turlach <berwin.turlach@gmail.com>
}
\keyword{distribution}
