% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NewBEVMixedModelCopula.R
\name{NewBEVMixedModelCopula}
\alias{NewBEVMixedModelCopula}
\title{Creates a bivariate mixed model extreme value copula}
\usage{
NewBEVMixedModelCopula(theta)
}
\arguments{
\item{theta}{real.}
}
\value{
A function that evaluates the bivariate asymmetric mixed model EV copula (with parameter \eqn{\theta}) at a given \eqn{2}-dimensional vector in the unit square.  The environment of the function also contains a function called \code{pdfCopula} that evaluates the probability density function of the bivariate asymmetric mixed model EV copula via automatic differentation.
}
\description{
Creates an instance of the bivariate asymmetric mixed model extreme value copula with parameter \eqn{\theta}.
}
\details{
The dependence function for this bivariate EV copula is \deqn{A(w) = \theta w^2 - \theta w + 1}
Necessary and sufficient conditions for the dependence function to be valid are
\itemize{
  \item \eqn{0 \le \theta \le 1}
}
}
\seealso{
\code{\link{NewBEVAsyMixedModelCopula}}
}
\author{
Berwin A. Turlach <berwin.turlach@gmail.com>
}
\keyword{distribution}
