% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateRV.CopApprox.R
\name{GenerateRV.CopApprox}
\alias{GenerateRV.CopApprox}
\title{Generates random variates from a copula approximation}
\usage{
\method{GenerateRV}{CopApprox}(obj, n, MH = FALSE, trace = FALSE,
  PDF = NULL, burnin = 500, thinning = 5, ...)
}
\arguments{
\item{obj}{object from which to sample.}

\item{n}{number of items to sample.}

\item{MH}{logical, should a Metropolis-Hastings algorithm be used to refine the sample?  Default is \code{FALSE}.}

\item{trace}{logical, indicating whether the function should be verbose.}

\item{PDF}{probability density function corresponding to copula used to create \code{obj}, only used if \code{MH} is \code{TRUE}; see \sQuote{Details}.}

\item{burnin}{the number of burn-in iterations of the MH sampler, only used if \code{MH} is \code{TRUE}, defaults to 500.}

\item{thinning}{the thining parameter, only used if \code{MH} is \code{TRUE}, defaults to 5.}

\item{\dots}{not used.}
}
\value{
A matrix of dimension \code{n} times \code{dim}, where \code{dim} is the dimension for which the copula approximation was determined.

If \code{MH} was \code{TRUE} the return value has an attribute called \sQuote{\code{AcceptanceRate}}, indicating the fraction of samples that were accepted in the Metropolis-Hastings step.  This fraction is based on all \code{burnin + (n-1)*thinning + 1} samples that are  initially generated from the approximation.
}
\description{
Method to sample random variates from an object of \code{\link{class}} \sQuote{CopApprox}.
}
\details{
If argument \code{MH} is \code{FALSE}, the default, random variates are directly sampled from the approximation, as described in Tajvidi and Turlach (2017).

If \code{MH} is \code{TRUE}, \code{GenerateRV} uses additionally a Metropolis-Hastings refinement.  It first samples from the approximation, but uses those samples then as proposals in a Metropolis-Hastings algorithm.  The latter needs the probability density function of the copula.  This density function has either to be passed to the argument \code{PDF}, or the copula (stored in argument \code{obj}) belonging to the approximation must have the density function (with name \sQuote{\code{pdfCopula}}) stored in its environment. In the latter case, the argument \code{PDF} can be \code{NULL} (its default).
}
\examples{
cop <- NewBEVAsyMixedModelCopula(theta=1, phi=-0.25)
approx1 <- GetApprox(cop)
approx2 <- GetApprox(cop, type = 1)
sample1 <- GenerateRV(approx1, 100)
plot(sample1)
sample2 <- GenerateRV(approx2, 100)
plot(sample2)
sample1 <- GenerateRV(approx1, 50, MH = TRUE, trace = TRUE)
plot(sample1)
sample2 <- GenerateRV(approx2, 50, MH = TRUE)
plot(sample2)

}
\references{
Tajvidi, N. and Turlach, B.A. (2017). A general approach to generate random variates for multivariate copulae, \emph{Australian & New Zealand Journal of Statistics}. Doi:10.1111/anzs.12209.
}
\seealso{
\code{\link{GetApprox}}
}
\keyword{distribution}
