% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{CID.Normalize}
\alias{CID.Normalize}
\title{Library size normalize}
\usage{
CID.Normalize(E)
}
\arguments{
\item{E}{Expression matrix}
}
\value{
Normalized expression matrix where each cell sums to the mean total counts
}
\description{
\code{CID.Normalize} normalizes the expression matrix to the mean library size.
}
\examples{
\dontrun{
# download single cell data for classification
file.dir = "https://cf.10xgenomics.com/samples/cell-exp/3.0.0/pbmc_1k_v3/"
file = "pbmc_1k_v3_filtered_feature_bc_matrix.h5"
download.file(paste0(file.dir, file), "Ex.h5")

# load data, process with Seurat
library(Seurat)
E = Read10X_h5(filename = "Ex.h5")

# observe average total counts
mean(Matrix::colSums(E))

# run normalization
E_norm = CID.Normalize(E)

# check normalization
kmu = mean(Matrix::colSums(E_norm))
head(kmu)
}
}
