% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/heatmaps.R
\name{RegionMatrix}
\alias{RegionMatrix}
\alias{RegionMatrix.Seurat}
\alias{RegionMatrix.ChromatinAssay}
\alias{RegionMatrix.default}
\title{Region enrichment analysis}
\usage{
RegionMatrix(object, ...)

\method{RegionMatrix}{Seurat}(
  object,
  regions,
  key,
  assay = NULL,
  group.by = NULL,
  idents = NULL,
  upstream = 3000,
  downstream = 3000,
  verbose = TRUE,
  ...
)

\method{RegionMatrix}{ChromatinAssay}(
  object,
  regions,
  key,
  assay = NULL,
  group.by = NULL,
  idents = NULL,
  upstream = 3000,
  downstream = 3000,
  verbose = TRUE,
  ...
)

\method{RegionMatrix}{default}(
  object,
  regions,
  key,
  assay = NULL,
  group.by = NULL,
  idents = NULL,
  upstream = 3000,
  downstream = 3000,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A Seurat or ChromatinAssay object}

\item{...}{Arguments passed to other methods}

\item{regions}{A \code{\link[GenomicRanges]{GRanges}} object containing the
set of genomic ranges to quantify}

\item{key}{Name to store resulting matrices under}

\item{assay}{Name of assay to use. If NULL, use the default assay}

\item{group.by}{Grouping variable to use when aggregating data across cells.
If NULL, use the active cell identities}

\item{idents}{Cell identities to include. If NULL, include all identities}

\item{upstream}{Number of bases to extend regions upstream}

\item{downstream}{Number of bases to extend regions downstream}

\item{verbose}{Display messages}
}
\value{
Returns a \code{\link[SeuratObject]{Seurat}} object
}
\description{
Count fragments within a set of regions for different groups of
cells.
}
\concept{heatmap}
