% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.detect.prob.R
\name{compute.detect.prob}
\alias{compute.detect.prob}
\title{Compute the detection probability given a sightability model}
\usage{
compute.detect.prob(
  data,
  sight.model,
  sight.beta,
  sight.beta.cov,
  check.args = FALSE
)
}
\arguments{
\item{data}{Data.frame containing covariates for sightability model}

\item{sight.model}{Formula with sightability model}

\item{sight.beta}{Parameter estimates (from fitted sightability model}

\item{sight.beta.cov}{Estimated variance-covariance matrix for  parameter estimates
from fitted sightability model.}

\item{check.args}{Should the sightability model arguments be checked for consistency/}
}
\value{
Vector of detection probabilities
}
\description{
Compute the detection probability given a sightability model
}
\examples{
sightability.table <- data.frame(VegCoverClass=1:5)
sight.beta <- c(4.2138, -1.5847)
sight.beta.cov <- matrix(c(0.7821634, -0.2820000,-0.2820000,  0.1114892), nrow=2)
sightability.table$detect.prob <- compute.detect.prob( sightability.table, 
                                                      ~VegCoverClass, 
                                                      sight.beta, 
                                                      sight.beta.cov)
sightability.table$SCF         <- compute.SCF        ( sightability.table,
                                                       ~VegCoverClass, 
                                                       sight.beta, 
                                                       sight.beta.cov)
sightability.table
#"Note that the SCF != 1/detect.prob because of correction terms for covariance of beta.terms"

}
\seealso{
\code{\link{compute.SCF}}
}
\author{
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
\keyword{methods}
