% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SieveSGDFunction.R
\name{sieve.sgd.preprocess}
\alias{sieve.sgd.preprocess}
\title{Preprocess the original data for sieve-SGD estimation.}
\usage{
sieve.sgd.preprocess(
  X,
  s = c(2),
  r0 = c(2),
  J = c(1),
  type = c("cosine"),
  interaction_order = c(3),
  omega = c(0.51),
  norm_feature = TRUE,
  norm_para = NULL,
  lower_q = 0.005,
  upper_q = 0.995
)
}
\arguments{
\item{X}{a data frame containing prediction features/ independent variables. The (i,j)-th element is the j-th dimension of the i-th sample's feature vector. 
So the number of rows equals to the sample size and the number of columns equals to the feature/covariate dimension. If the complete data set is large, this can be a representative subset of it (ideally have more than 1000 samples).}

\item{s}{numerical array. Smoothness parameter. Default is 2. The elements of this array should take values greater than 0.5. The larger s is, the smoother we are assuming the truth to be.}

\item{r0}{numerical array. Initial learning rate/step size. The step size at each iteration will be r0*(sample size)^(-1/(2s+1)), which is slowly decaying.}

\item{J}{numerical array. Initial number of basis functions. The number of basis functions at each iteration will be J*(sample size)^(1/(2s+1)), which is slowly increasing. We recommend use J that is at least the dimension of predictor, i.e. the column number of the X matrix.}

\item{type}{a string. It specifies what kind of basis functions are used. The default is (aperiodic) cosine basis functions, which is suitable for most purpose.}

\item{interaction_order}{a number. It also controls the model complexity. 1 means fitting an additive model, 2 means fitting a model allows, 3 means interaction terms between 3 dimensions of the feature, etc. The default is 3. 
For large sample size, lower dimension problems, try a larger value (but need to be smaller than the dimension of original features); for smaller sample size and higher dimensional problems, try set it to a smaller value (1 or 2).}

\item{omega}{the rate of dimension-reduction parameter. Default is 0.51, usually do not need to change.}

\item{norm_feature}{a logical variable. Default is TRUE. It means sieve_preprocess will rescale the each dimension of features to 0 and 1. Only set to FALSE when user already manually rescale them between 0 and 1.}

\item{norm_para}{a matrix. It specifies how the features are normalized. For training data, use the default value NULL.}

\item{lower_q}{lower quantile used in normalization. Default is 0.01 (1\% quantile).}

\item{upper_q}{upper quantile used in normalization. Default is 0.99 (99\% quantile).}
}
\value{
A list containing the necessary information for next step model fitting. Typically, the list is used as the main input of sieve.sgd.solver.
\item{s.size.sofar}{a number. Number of samples has been processed so far.}
\item{type}{a string. The type of basis funtion.}
\item{hyper.para.list}{a list of hyperparameters.}
\item{index.matrix}{a matrix. Identifies the multivariate basis functions used in fitting.}
\item{index.row.prod}{the index product for each basis function. It is used in calculating basis function - specific learning rates.}
\item{inf.list}{a list storing the fitted results. It has a length of "number of unique combinations of the hyperparameters". The component of inf.list is itself a list, it has a hyper.para.index domain to specify its corresponding hyperparameters (need to be used together with hyper.para.list). Its rolling.cv domain is the progressive validation statistics for hyperparameter tuning; beta.f is the regression coefficients for the first length(beta.f) basis functions, the rest of the basis have 0 coefficients.}
\item{norm_para}{a matrix. It records how each dimension of the feature/predictor is rescaled, which is useful when rescaling the testing sample's predictors.}
}
\description{
Preprocess the original data for sieve-SGD estimation.
}
\examples{
xdim <- 1 #1 dimensional feature
#generate 1000 training samples
TrainData <- GenSamples(s.size = 1000, xdim = xdim)
#use 50 cosine basis functions
type <- 'cosine'
sieve.model <- sieve.sgd.preprocess(X = TrainData[,2:(xdim+1)], type = type)
}
