% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOE.R
\name{MOE}
\alias{MOE}
\title{Detecting cellwise outliers using Shapley values based on local outlyingness.}
\usage{
MOE(
  x,
  mu,
  Sigma,
  Sigma_inv = NULL,
  step_size = 0.1,
  min_deviation = 0,
  max_step = NULL,
  local = TRUE,
  max_iter = 1000,
  q = 0.99,
  check_outlyingness = FALSE,
  check = TRUE,
  cells = NULL,
  method = "cellMCD"
)
}
\arguments{
\item{x}{Data vector with \eqn{p} entries or data matrix with \eqn{n \times p} entries containing only numeric entries.}

\item{mu}{Either \code{NULL} (default) or mean vector of \code{x}. If NULL, \code{method} is used for parameter estimation.}

\item{Sigma}{Either \code{NULL} (default) or covariance matrix \eqn{p \times p} of \code{x}. If NULL, \code{method} is used for parameter estimation.}

\item{Sigma_inv}{Either \code{NULL} (default) or Sigma's inverse \eqn{p \times p} matrix.
If \code{NULL}, the inverse of \code{Sigma} is computed using \code{solve(Sigma)}.}

\item{step_size}{Numeric. Step size for the imputation of outlying cells, with \code{step_size} \eqn{\in [0,1]}. Defaults to \eqn{0.1}.}

\item{min_deviation}{Numeric. Detection threshold, with \code{min_deviation} \eqn{\in [0,1]}. Defaults to \eqn{0.2}}

\item{max_step}{Either \code{NULL} (default) or an integer. The maximum number of steps in each iteration.
If \code{NULL}, \code{max_step} \eqn{= p}.}

\item{local}{Logical. If TRUE (default), the non-central Chi-Squared distribution is used to determine the cutoff value based on \code{mu_tilde}.}

\item{max_iter}{Integer. The maximum number of iterations.}

\item{q}{Numeric. The quantile of the Chi-squared distribution for detection and imputation of outliers. Defaults to \eqn{0.99}.}

\item{check_outlyingness}{Logical. If TRUE (default), the outlyingness is rechecked after applying \code{min_deviation}.}

\item{check}{Logical. If \code{TRUE} (default), inputs are checked before running the function
and an error message is returned if one of the inputs is not as expected.}

\item{cells}{Either \code{NULL} (default) or a vector/matrix of the same dimension as \code{x},
indicating the outlying cells. The matrix must contain only zeros and ones, or \code{TRUE}/\code{FALSE}.}

\item{method}{Either "cellMCD" (default) or "MCD". Specifies the method used for parameter estimation if \code{mu} and/or \code{Sigma} are not provided.}
}
\value{
A list of class \code{shapley_algorithm} (\code{\link{new_shapley_algorithm}}) containing the following:
\item{\code{x}}{A \eqn{p}-dimensional vector (or a \eqn{n \times p} matrix) containing the imputed data.}
\item{\code{phi}}{A \eqn{p}-dimensional vector (or a \eqn{n \times p} matrix) containing the Shapley values (outlyingness-scores) of \code{x}; see \code{\link{shapley}}.}
\item{\code{mu_tilde}}{A \eqn{p}-dimensional vector (or a \eqn{n \times p} matrix) containing the alternative reference points based on the regular cells of the original observations.}
\item{\code{x_original}}{A \eqn{p}-dimensional vector (or a \eqn{n \times p} matrix) containing the original data.}
\item{\code{x_original}}{The non-centrality parameters for the Chi-Squared distribution}
\item{\code{x_history}}{A list with \eqn{n} elements, each containing the path of how the original data vector was modified.}
\item{\code{phi_history}}{A list with \eqn{n} elements, each containing the Shapley values corresponding to \code{x_history}.}
\item{\code{mu_tilde_history}}{A list with \eqn{n} elements, each containing the alternative reference points corresponding to \code{x_history}.}
\item{\code{S_history}}{A list with \eqn{n} elements, each containing the indices of the outlying cells in each iteration.}
}
\description{
The \code{MOE} function indicates outlying cells for
a data vector with \eqn{p} entries or data matrix with \eqn{n \times p} entries containing only numeric entries \code{x}
for a given center \code{mu} and covariance matrix \code{Sigma} using the Shapley value.
It is a more sophisticated alternative to the \code{\link{SCD}} algorithm,
which uses the information of the regular cells to derive an alternative reference point  \insertCite{Mayrhofer2022}{ShapleyOutlier}.
}
\examples{
p <- 5
mu <- rep(0,p)
Sigma <- matrix(0.9, p, p); diag(Sigma) = 1
Sigma_inv <- solve(Sigma)
x <- c(0,1,2,2.3,2.5)
MOE_x <- MOE(x = x, mu = mu, Sigma = Sigma)
plot(MOE_x)

library(MASS)
set.seed(1)
n <- 100; p <- 10
mu <- rep(0,p)
Sigma <- matrix(0.9, p, p); diag(Sigma) = 1
X <- mvrnorm(n, mu, Sigma)
X[sample(1:(n*p), 100, FALSE)] <- rep(c(-5,5),50)
MOE_X <- MOE(X, mu, Sigma)
plot(MOE_X, subset = 20)
}
\references{
\insertAllCited{}
}
