% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{GetAssayData}
\alias{GetAssayData}
\alias{GetAssayData.Assay}
\alias{GetAssayData.Seurat}
\title{General accessor function for the Assay class}
\usage{
GetAssayData(object, ...)

\method{GetAssayData}{Assay}(object, slot = "data", ...)

\method{GetAssayData}{Seurat}(object, slot = "data", assay = NULL, ...)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{slot}{Specific information to pull (i.e. counts, data, scale.data, ...)}

\item{assay}{Name of assay to pull data from}
}
\value{
Returns info from requested slot
}
\description{
This function can be used to pull information from any of the slots in the Assay class. For
example, pull one of the data matrices("counts", "data", or "scale.data").
}
\examples{
# Get the data directly from an Assay object
GetAssayData(object = pbmc_small[["RNA"]], slot = "data")[1:5,1:5]

# Get the data from a specific Assay in a Seurat object
GetAssayData(object = pbmc_small, assay = "RNA", slot = "data")[1:5,1:5]

}
