% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{PrepSCTIntegration}
\alias{PrepSCTIntegration}
\title{Prepare an object list that has been run through SCTransform for integration}
\usage{
PrepSCTIntegration(object.list, assay = NULL, anchor.features = 2000,
  sct.clip.range = NULL, verbose = TRUE)
}
\arguments{
\item{object.list}{A list of objects to prep for integration}

\item{assay}{Name or vector of assay names (one for each object) that correspond
to the assay that SCTransform has been run on. If NULL, the current default
assay for each object is used.}

\item{anchor.features}{Can be either:
\itemize{
  \item{A numeric value. This will call \code{\link{SelectIntegrationFeatures}}
  to select the provided number of features to be used in anchor finding}
  \item{A vector of features to be used as input to the anchor finding
  process}
}}

\item{sct.clip.range}{Numeric of length two specifying the min and max values
the Pearson residual will be clipped to}

\item{verbose}{Display output/messages}
}
\value{
An object list with the \code{scale.data} slots set to the anchor
features
}
\description{
Prepare an object list that has been run through SCTransform for integration
}
