% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_modal.R
\name{HTOHeatmap}
\alias{HTOHeatmap}
\title{Hashtag oligo heatmap}
\usage{
HTOHeatmap(object, hto.classification = "hto_classification",
  global.classification = "hto_classification_global", assay.type = "HTO",
  num.cells = 5000, singlet.names = NULL, ...)
}
\arguments{
\item{object}{Seurat object. Assumes that the hash tag oligo (HTO) data has been added and normalized, and demultiplexing has been run with HTODemux().}

\item{hto.classification}{The naming for object@meta.data slot with classification result from HTODemux().}

\item{global.classification}{The slot for object@meta.data slot specifying a cell as singlet/doublet/negative.}

\item{assay.type}{Hashtag assay name.}

\item{num.cells}{Number of cells to plot. Default is to choose 5000 cells by random subsampling, to avoid having to draw exceptionally large heatmaps.}

\item{singlet.names}{Namings for the singlets. Default is to use the same names as HTOs.}

\item{...}{Additional arguments for DoHeatmap().}
}
\value{
Returns a ggplot2 plot object.
}
\description{
Draws a heatmap of hashtag oligo signals across singlets/doublets/negative cells. Allows for the visualization of HTO demultiplexing results.
}
\examples{
\dontrun{
object <- HTODemux(object)
HTOHeatmap(object)
}
}
