% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{AddSmoothedScore}
\alias{AddSmoothedScore}
\title{Calculate smoothed expression values}
\usage{
AddSmoothedScore(object, genes.fit = NULL, dim.1 = 1, dim.2 = 2,
  reduction.use = "tsne", k = 30, do.log = FALSE, do.print = FALSE,
  nn.eps = 0)
}
\arguments{
\item{object}{Seurat object}

\item{genes.fit}{Genes to calculate smoothed values for}

\item{dim.1}{Dimension 1 to use for dimensional reduction}

\item{dim.2}{Dimension 2 to use for dimensional reduction}

\item{reduction.use}{Dimensional reduction to use}

\item{k}{k-param for k-nearest neighbor calculation. 30 by default}

\item{do.log}{Whether to perform smoothing in log space. Default is false.}

\item{do.print}{Print progress (output the name of each gene after it has
been imputed).}

\item{nn.eps}{Error bound when performing nearest neighbor seach using RANN;
default of 0.0 implies exact nearest neighbor search}
}
\description{
Smooths expression values across the k-nearest neighbors based on dimensional reduction
}
\examples{
pbmc_small <- AddSmoothedScore(object = pbmc_small, genes.fit = "MS4A1", reduction.use = "pca")

}
