% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_determination.R
\name{ClassifyCells}
\alias{ClassifyCells}
\title{Classify New Data}
\usage{
ClassifyCells(object, classifier, training.genes = NULL,
  training.classes = NULL, new.data = NULL, ...)
}
\arguments{
\item{object}{Seurat object on which to train the classifier}

\item{classifier}{Random Forest classifier from BuildRFClassifier. If not provided,
it will be built from the training data provided.}

\item{training.genes}{Vector of genes to build the classifier on}

\item{training.classes}{Vector of classes to build the classifier on}

\item{new.data}{New data to classify}

\item{...}{additional parameters passed to ranger}
}
\value{
Vector of cluster ids
}
\description{
Classify new data based on the cluster information of the provided object.
Random Forests are used as the basis of the classification.
}
\examples{
pbmc_small
# take the first 10 cells as test data and train on the remaining 70 cells
test.pbmc <- SubsetData(object = pbmc_small, cells.use = pbmc_small@cell.names[1:10])
train.pbmc <- SubsetData(object = pbmc_small, cells.use = pbmc_small@cell.names[11:80])
predicted.classes <- ClassifyCells(
  object = train.pbmc,
  training.classes = train.pbmc@ident,
  new.data = test.pbmc@data
)

}
