% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{AverageExpression}
\alias{AverageExpression}
\title{Averaged gene expression by identity class}
\usage{
AverageExpression(object, genes.use = NULL, return.seurat = FALSE,
  add.ident = NULL, use.scale = FALSE, use.raw = FALSE,
  show.progress = TRUE, ...)
}
\arguments{
\item{object}{Seurat object}

\item{genes.use}{Genes to analyze. Default is all genes.}

\item{return.seurat}{Whether to return the data as a Seurat object. Default is false.}

\item{add.ident}{Place an additional label on each cell prior to averaging (very useful if you want to observe cluster averages, separated by replicate, for example).}

\item{use.scale}{Use scaled values for gene expression}

\item{use.raw}{Use raw values for gene expression}

\item{show.progress}{Show progress bar (default is T)}

\item{...}{Arguments to be passed to methods such as \code{Seurat}}
}
\value{
Returns a matrix with genes as rows, identity classes as columns.
}
\description{
Returns gene expression for an 'average' single cell in each identity class
}
\details{
Output is in log-space when \code{return.seurat = TRUE}, otherwise it's in non-log space.
Averaging is done in non-log space.
}
\examples{
head(AverageExpression(object = pbmc_small))

}
