\name{panellipse.session}
\alias{panellipse.session}

\title{Repetability of panelists descriptions studied by confidence ellipses around products per session}

\description{Virtual panels are generated using Boostrap techniques in order to display
confidence ellipses around products.}

\usage{
panellipse.session(donnee,col.p,col.j,col.s,firstvar,lastvar=ncol(donnee),alpha=0.05,coord=c(1,2),scale.unit=TRUE,nbsimul=500,nbchoix=NULL,level.search.desc=0.5,centerbypanelist=TRUE,scalebypanelist=FALSE)
}

\arguments{
  \item{donnee}{a data frame made up of at least two qualitative variables 
  (\emph{product}, \emph{panelist}) and a set of quantitative variables (sensory descriptors)}  
  \item{col.p}{the position of the \emph{product} variable}
  \item{col.j}{the position of the \emph{panelist} variable}
  \item{col.s}{the position of the \emph{session} variable}
  \item{firstvar}{the position of the first sensory descriptor}
  \item{lastvar}{the position of the last sensory descriptor (by default the last column of \code{donnee})}
  \item{alpha}{the confidence level of the ellipses}
  \item{coord}{a length 2 vector specifying the components to plot}
  \item{scale.unit}{boolean, if T the descriptors are scaled to unit variance}
  \item{nbsimul}{the number of simulations (corresponding to the number of virtual panels) used to compute the ellipses}
  \item{nbchoix}{the number of panelists forming a virtual panel, by default the number of panelists in the original panel}  
  \item{level.search.desc}{the threshold above which a descriptor is not considered as discriminant according to AOV model \code{"descriptor=Product+Panelist"}}
  \item{centerbypanelist}{boolean, if T center the data by panelist before the construction of the axes}
  \item{scalebypanelist}{boolean, if T scale the data by panelist before the construction of the axes (by default, FALSE
  is assigned to that parameter)}
}


\details{
panellipse.session, step by step:\cr
Step 1 Construct a data frame by session \cr
Step 2 Performs a selection of discriminating descriptors with respect to a threshold set by users \cr
Step 3 MFA is computed with one group for one session \cr
Step 4 Virtual panels are generated using Boostrap techniques; the number of panels as well as their size
are set by users with the \emph{nbsimul} and \emph{nbchoix} parameters \cr
Step 5 Coordinates of the products with respect to each virtual panels are computed \cr
Step 6 Each product is then circled by its confidence ellipse generated by virtual panels and
comprising (1-alpha)*100 percent of the virtual products
}
\value{
Returns a graph of the products as well as a correlation circle of the descriptors.\cr

Returns a graph where each product is displayed with respect to a panel and to each panelist composing
the panel; products described by the panel are displayed as square, they are displayed as circle when
they are described by each panelist.\cr

Returns a graph where each product is circled by its confidence ellipse generated by virtual panels.\cr

Returns a graph where each partial product is circled by its confidence ellipse generated by virtual panels.\cr

Returns an index of the sessions' reproductibility obtained by PCA performed on homologous descriptors (variables
are sorted in a descending way according to this index).
}

\seealso{\code{\link{panellipse}}}

\references{
Husson F., Le Dien S. & Pags J.  (2005). Confidence ellipse for the sensory profiles obtained by Principal Components Analysis. \emph{Food Quality and Preference}.  16 (3), 245-250. \cr
Pags J. & Husson F. (2005). Multiple Factor Analysis with confidence ellipses: a methodology to study the relationships between sensory and instrumental data. To be published in \emph{Journal of Chemometrics}.
}
\author{
Franois Husson, Sbastien L}

\examples{
\dontrun{
data(chocolates)
panellipse.session(chocolates,col.p=4,col.j=1,col.s=2,firstvar=5)
}
}
\keyword{multivariate}
