% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qwerty.dist.R
\name{qwerty.dist}
\alias{qwerty.dist}
\title{QWERTY Distance for Same Length Words}
\usage{
qwerty.dist(wordA, wordB)
}
\arguments{
\item{wordA}{Character vector.
Word to be compared}

\item{wordB}{Character vector.
Word to be compared}
}
\value{
Numeric value for distance between \code{wordA} and \code{wordB}
}
\description{
Computes QWERTY Distance for words that have
the same number of characters. Distnace is computed based on
the number of keys a character is away from another character
on a QWERTY keyboard
}
\examples{
#Identical values for Damerau-Levenshtein and QWERTY
qwerty.dist("sog","dpg")

stringdist::stringdist("sog","dpg",method="dl")

#Greater distance for QWERTY than Damerau-Levenshtein
qwerty.dist("sog","dmg")

stringdist::stringdist("sog","dmg",method="dl")

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
