% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partboot_test.R
\name{partboot.test}
\alias{partboot.test}
\title{Test for partboot}
\usage{
partboot.test(object)
}
\arguments{
\item{object}{An object from \link[SemNetCleaner]{partboot}}
}
\value{
Returns test statistics for specified measures
}
\description{
Bootstraps (without replacement) the nodes in the network and computes global network characteristics
}
\examples{
#finalize rmatA
finalCmat <- finalize(convmat)
#finalize rmatB
finalRmat <- finalize(rmat)

#equate rmatA and rmatB
eq1 <- equate(finalCmat,finalRmat)

#obtain respective equated response matrices
eqCmat <- eq1$rmatA
eqRmat <- eq1$rmatB

\donttest{
results <- partboot(eqCmat, eqRmat, corr = "cosine", cores = 4)

partboot.test(results, paired = TRUE, labels = labs)
}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
