% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PF.R
\name{PF}
\alias{PF}
\title{Pathfinder Network}
\usage{
PF(data, progBar = TRUE)
}
\arguments{
\item{data}{Matrix or data frame.
A binary response matrix}

\item{progBar}{Boolean.
Should a progress bar be displayed?
Defaults to \code{TRUE}}
}
\value{
An adjacency matrix
}
\description{
Estimates a pathfinder network using the MST-Pathfinder
Network method from Quirin et al. (2008; see also Schvaneveldt, 1990)
}
\examples{
# Obtain data
data <- open.binary

\dontrun{
# Estimate network
pf.net <- PF(data)
}

}
\references{
Quirin, A., Cordon, O., Guerrero-Bote, V. P., Vargas-Quesada, B., & Moya-Aneon, F. (2008)
A quick MST-based algorithm to obtain Pathfinder networks (Inf, n-1).
\emph{Journal of the American Society for Information Science and Technology}, \emph{59}, 1912-1924.

Schvaneveldt, R. W. (1990).
\emph{Pathfinder associative networks: Studies in knowledge organization}.
Norwood, NJ: Ablex Publishing.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
