% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoboost.R
\name{summary.selectboost}
\alias{summary.selectboost}
\title{Summarize a selectboost analysis}
\usage{
\method{summary}{selectboost}(
  object,
  crit.func = mean,
  crit.int = "mean",
  custom.values.lim = NULL,
  index.lim = NULL,
  alpha.conf.level = 0.99,
  force.dec = TRUE,
  ...
)
}
\arguments{
\item{object}{Numerical matrix. Result of selectboost (autoboost, fastboost, ...).}

\item{crit.func}{Function . Defaults to the \code{mean} function.}

\item{crit.int}{Character value. Mean or median based confidence intervals. Defaults to \code{"mean"} based confidence intervals.}

\item{custom.values.lim}{Vector of numeric values. Defults to \code{NULL}.}

\item{index.lim}{Vector of numeric values. Defults to \code{NULL}.}

\item{alpha.conf.level}{Numeric value. Defults to \code{0.99}.}

\item{force.dec}{Boolean. Force trajectories to be non-increasing.}

\item{...}{Additionnal arguments. Passed to the \code{crit.func} function.}
}
\value{
A list with the results.
}
\description{
Summarize a selectboost analysis.
}
\details{
\code{summary.selectboost} returns a list with the results.
}
\examples{
data(autoboost.res.x)
summary(autoboost.res.x)
summary(autoboost.res.x, force.dec=FALSE)

data(autoboost.res.x.adapt)
summary(autoboost.res.x.adapt)

data(autoboost.res.x2)
summary(autoboost.res.x2)
summary(autoboost.res.x2, force.dec=FALSE)

data(autoboost.res.x2.adapt)
summary(autoboost.res.x2.adapt)

data(fastboost.res.x)
summary(fastboost.res.x)
summary(fastboost.res.x, force.dec=FALSE)

data(fastboost.res.x.adapt)
summary(fastboost.res.x.adapt)

data(fastboost.res.x2)
summary(fastboost.res.x2)
summary(fastboost.res.x2, force.dec=FALSE)

data(fastboost.res.x2.adapt)
summary(fastboost.res.x2.adapt)
}
\references{
\emph{selectBoost: a general algorithm to enhance the performance of variable selection methods in correlated datasets}, Frédéric Bertrand, Ismaïl Aouadi, Nicolas Jung, Raphael Carapito, Laurent Vallat, Seiamak Bahram, Myriam Maumy-Bertrand, \url{https://arxiv.org/abs/1810.01670}
}
\seealso{
\code{\link{fastboost}}, \code{\link{autoboost}}

Other Selectboost analyse functions: 
\code{\link{force.non.inc}()},
\code{\link{plot.selectboost}()}
}
\author{
Frederic Bertrand, \email{frederic.bertrand@math.unistra.fr}
}
\concept{Selectboost analyse functions}
