% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TESTS.R
\name{calc.LR}
\alias{calc.LR}
\alias{calc.LR.default}
\title{Likelihood Ratio Test (G test) for Tables}
\usage{
calc.LR(x, y = NULL, ...)

\method{calc.LR}{default}(x, y = NULL, ...)
}
\arguments{
\item{x}{A vector or a matrix.}

\item{y}{A vector that is ignored if x is a matrix and required if x is a vector.}

\item{\dots}{Extra parameters pass to the \code{\link{table}} function.}
}
\description{
Computes the likelihood ratio test (G test) for contingency tables. Currently does not do Williams' and Yates' correction.
}
\examples{
# 2000 General Social Survey-Sex and Party affiliation
# Agresti (1996) p. 38:

gss <- data.frame(
   expand.grid(sex=c("female", "male"),
   party=c("dem", "indep", "rep")),
   count=c(762,484,327,239, 468,477))

# expand it:
# GSS <- gss[rep(1:nrow(gss), gss[["count"]]),]
GSS = untable(gss, freq = "count")

calc.LR(GSS$party, GSS$sex)
}
\references{
Agresti, Alan (1996) \emph{Introduction to categorical data
 analysis}. NY: John Wiley and Sons

Smithson, M.J. (2003) \emph{Confidence Intervals, Quantitative
 Applications in the Social Sciences Series, No. 140}.
 Thousand Oaks, CA: Sage. pp. 39-41.
}
\keyword{Tests}

