% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SILO.R
\name{SILOLoad}
\alias{SILOLoad}
\title{Import multiple SILO files}
\usage{
SILOLoad(sites, path = getwd(), startdate, enddate)
}
\arguments{
\item{sites}{a vector of Station numbers (e.g. c("24001","24002","24003")) to import. The function expects the file to be called "24001.txt".}

\item{path}{Location where the file is located. Use "/" or "\\\\" for folders. Defaults to getwd() if not specified.}

\item{startdate}{Start date of data to load, in format "YYYY-MM-DD". Defaults to start of the file if not provided}

\item{enddate}{End date of data to load, in format "YYYY-MM-DD". Defaults to end of the file if not provided}
}
\value{
a list of data from the file, with members: 
\describe{
\item{tsd}{the raw data as a daily zoo object} 
\item{Site}{the name of the site}
\item{Station}{the station number}
\item{Lon}{Longitude}
\item{Lat}{Latitude}
\item{start}{the first date with good quality rainfall data}
\item{end}{the last date with good quality rainfall data}
\item{goodpct}{the percentage of good quality coded rainfall data between start and end}
}
}
\description{
Import multiple SILO files
}
\examples{
\dontrun{
X<-SILOLoad(c("24001","24002","24003"),path="./SWTools/extdata")
}
}
