% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_map.R
\name{base_map}
\alias{base_map}
\title{Create background map}
\usage{
base_map(
  bbox,
  bg_crs = 4326,
  vector_only = FALSE,
  maptype = "stamen_toner_lite",
  zoom = NULL,
  ...
)
}
\arguments{
\item{bbox}{Bounding box vector.}

\item{bg_crs}{EPSG code or \code{st_crs} object for the returned map.}

\item{vector_only}{Logical, draw only a simple vector-based map.}

\item{maptype}{Background map type from Stadia Maps (formerly Stamen)
(\url{https://docs.stadiamaps.com/}); one of c("stamen_terrain",
"stamen_toner", "stamen_toner_lite", "stamen_watercolor", "alidade_smooth",
"alidade_smooth_dark", "outdoors", "stamen_terrain_background",
"stamen_toner_background", "stamen_terrain_labels", "stamen_terrain_lines",
"stamen_toner_labels", "stamen_toner_lines").}

\item{zoom}{Zoom level for the base map created when \code{bg_map} is not
specified.  An integer value, 5 - 15, with higher numbers providing  more
detail.  If not provided, a zoom level is autoscaled based on \code{bbox}
parameters.}

\item{...}{Additional arguments to be passed to \code{ggmap::get_stadiamap}}
}
\value{
Returns a \code{ggplot2} object.
}
\description{
Create a background map from a bounding box using Stamen Map tiles or a crude
vector-based map.
}
\details{
A helper, or stand-alone, function to create background map based on
  based on raster map tiles retrieved with \code{ggmap::get_stadiamap}.  If
  \code{ggmap} is unavailable, the function creates a basic map using
  county-level polygon files.  This map is fairly crude and should be
  considered a placeholder.
}
\examples{
#Simple, low-zoom  map for testing
bound_box <- c(-77.393, 38.277, -75.553, 39.741)
(x <- base_map(bound_box, zoom = 7, maptype = 'stamen_toner_lite'))


\donttest{
# Default zoom map with terrain maptype.
y <- base_map(bound_box, maptype = 'stamen_terrain')
}
}
\author{
Dave Eslinger
}
\concept{analyze}
