% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res_sk_map.R
\name{res_sk_map}
\alias{res_sk_map}
\title{Local Reserve Map With Seasonal Kendall Results}
\usage{
res_sk_map(
  nerr_site_id,
  stations,
  sk_result = NULL,
  bbox,
  shp,
  station_labs = TRUE,
  lab_loc = NULL,
  bg_map = NULL,
  zoom = NULL,
  maptype = "toner-lite"
)
}
\arguments{
\item{nerr_site_id}{chr string of the reserve to make, first three characters used by NERRS}

\item{stations}{chr string of the reserve stations to include in the map}

\item{sk_result}{vector of values denoting direction and significance of seasonal kendall results. Result should be \code{c('inc', 'dec', 'insig', 'insuff')} for significant positive, significant negative, no significant results, and insufficient data to calculate result.}

\item{bbox}{a bounding box associated with the reserve. Should be in the format of c(xmin, ymin, xmax, ymax).}

\item{shp}{{sf} data frame (preferred) or SpatialPolygons object}

\item{station_labs}{logical, should stations be labeled? Defaults to \code{TRUE}}

\item{lab_loc}{chr vector of 'R' and 'L', one letter for each station. if no \code{lab_loc} is specified then labels will default to the left.}

\item{bg_map}{a georeferenced \code{ggmap} or \code{ggplot} object used as a background map, generally provided by a call to \code{\link{base_map}}. If \code{bg_map} is specified, \code{maptype} and \code{zoom} are ignored.}

\item{zoom}{Zoom level for the base map created when \code{bg_map} is not specified.  An integer value, 5 - 15, with higher numbers providing  more detail.  If not provided, a zoom level is autoscaled based on \code{bbox} parameters.}

\item{maptype}{Background map type from Stamen Maps (\url{http://maps.stamen.com/}); one of c("terrain", "terrain-background", "terrain-labels", "terrain-lines", "toner", "toner-2010", "toner-2011", "toner-background", "toner-hybrid", "toner-labels", "toner-lines", "toner-lite", "watercolor").}
}
\value{
returns a \code{ggplot} object.
}
\description{
Create a stylized reserve-level map of seasonal kendall results for use with the reserve level reporting template
}
\details{
Creates a stylized, reserve-level base map for displaying seasonal kendall results from \code{sk_seasonal}. The user can specify the reserve and stations to plot. The user can also specify a bounding box. For multi-component reserves, the user should specify a bounding box that highlights the component of interest.

To display seasonal trends, the user must specify \code{c('inc', 'dec', 'insig', 'insuff')} for each station listed in the \code{stations} argument.
}
\examples{
## A compact reserve

### set plotting parameters
stations <- sampling_stations[(sampling_stations$NERR.Site.ID == 'elk'
     & sampling_stations$Status == 'Active'
     & sampling_stations$isSWMP == "P"), ]$Station.Code
     to_match <- c('wq')
stns <- stations[grep(paste(to_match, collapse = '|'), stations)]
shp_fl <- elk_spatial
bounding_elk <- c(-121.8005, 36.7779, -121.6966, 36.8799)
trnds <- c('inc', 'dec', 'insuff', 'insig')

### Low zoom and default maptype plot (for CRAN testing, not recommended)
#    Lower zoom number gives coarser text and fewer features
(x_low <- res_sk_map('elk', stations = stns, sk_result = trnds,
                 bbox = bounding_elk, shp = shp_fl,
                 zoom = 10))

\donttest{

### Default zoom and maptype
x_def <- res_sk_map('elk', stations = stns, sk_result = trnds,
                 bbox = bounding_elk, shp = shp_fl)

### Higher zoom number gives more details, but those may not be visible
x_14 <- res_sk_map('elk', stations = stns, sk_result = trnds,
                 bbox = bounding_elk, shp = shp_fl,
                 zoom = 14)

### Different maptypes may be used.
x_terrain <- res_sk_map('elk', stations = stns, sk_result = trnds,
                 bbox = bounding_elk, shp = shp_fl,
                 maptype = 'terrain')
### A multicomponent reserve (showing two different bounding boxes)

#  set plotting parameters
stations <- sampling_stations[(sampling_stations$NERR.Site.ID == 'cbm'
         & sampling_stations$Status == 'Active'
         & sampling_stations$isSWMP == "P"), ]$Station.Code
         to_match <- c('wq')
stns <- stations[grep(paste(to_match, collapse = '|'), stations)]
shp_fl <- cbm_spatial
bounding_cbm_1 <- c(-77.393, 38.277, -75.553, 39.741)
bounding_cbm_2 <- c(-76.8,  38.7, -76.62,  38.85)
trnds <- c('inc', 'insuff', 'dec', 'insig')

#   plot
y <- res_sk_map('cbm', stations = stns, sk_result = trnds,
                 bbox = bounding_cbm_1, shp = shp_fl)

z <- res_sk_map('cbm', stations = stns, sk_result = trnds,
                 bbox = bounding_cbm_2, shp = shp_fl)
}
}
\author{
Julie Padilla, Dave Eslinger
}
\concept{analyze}
