% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVN.R
\name{SVN_links}
\alias{SVN_links}
\title{Statistical validated networks}
\usage{
SVN_links(states_vs_t, alpha = 0.01, MHT.correction = "bonferroni",
  exclude.states = NULL, states.pair.types = "all",
  alternative = "overexpression")
}
\arguments{
\item{states_vs_t}{a matrix with time in lines and individual states in
columns}

\item{alpha}{the family-wise error rate in the case of Bonferroni
multiple-hypothesis correction, or the false discovery rate in the case of
the FDR multiple hypothesis correction}

\item{MHT.correction}{the type of multiple hypothesis correction}

\item{exclude.states}{a vector of states to remove from states_vs_t}

\item{states.pair.types}{accepted value: "all", "same", "different": selects
which kind of state pairs are tested: if there are two states e.g. (1,2),
"all" allows (1,1), (2,2) and (1,2); "same" allows (1,1) and (2,2), while
"different" allows (1,2)}

\item{alternative}{a string either equal to "overexpression" or "underexpression"}
}
\value{
a data.table object of the node pairs significantly correlated at the
  alpha level. The columns are: link_id: a unique identifier for links; i and j are the node names; si and sj are their states;  pv is the value associated to the link; threshold is the Multiple Hypothesis Testing-adjusted p-value threshold (only links with pv<=threshold are kept)
}
\description{
Statistical validated networks
}
\examples{
x=sample(c(1,0),1000,replace = TRUE)
xx=x; x[1]=1-x[1]   # one modifies just one element
x_rev=rev(x)
y=sample(c(1,0),1000,replace = TRUE)
M=cbind(x,xx,x_rev,y)
mylinks=SVN_links(M)
print(mylinks)
# one can compute clusters as well
myclusters=SVN_clusters(mylinks)
}
