% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svmmajcrossval.R
\name{svmmajcrossval}
\alias{svmmajcrossval}
\title{k-fold Cross-Validation of SVM-Maj}
\usage{
svmmajcrossval(X, y, search.grid = list(lambda = 2^seq(5, -5, length.out
  = 19)), ..., convergence = 1e-04, weights.obs = 1,
  check.positive = TRUE, mc.cores = getOption("mc.cores"),
  options = NULL, verbose = FALSE, ngroup = 5, groups = NULL,
  return.model = FALSE)
}
\arguments{
\item{X}{A data frame (or object coercible by
\code{\link[base]{as.data.frame}} to a data frame) consisting the attributes.}

\item{y}{A factor (or object coercible by \code{\link[base]{factor}} to a
factor) consisting the class labels.}

\item{search.grid}{A list with for each factor the range of values to search
for.}

\item{...}{Other arguments to be passed through \code{svmmaj}.}

\item{convergence}{Specifies the convergence criterion for \code{svmmaj}.
Default is \code{1e-08}.}

\item{weights.obs}{Weights for the classes.}

\item{check.positive}{Specifies whether a check should be performed for
positive \code{lambda} and \code{weights.obs}.}

\item{mc.cores}{the number of cores to be used (for parallel computing)}

\item{options}{additional settings used in the \code{svmmaj} algorithm}

\item{verbose}{\code{=TRUE} shows the progress of the
cross-validation.}

\item{ngroup}{The number of groups to be divided into.}

\item{groups}{A predetermined group division for performing the cross
validation.}

\item{return.model}{\code{=TRUE} estimates the model with the optimal
parameters.}
}
\value{
\item{loss.opt}{ The minimum (weighted) missclassification rate
found in out-of-sample training along the search grid. } \item{param.opt}{
The level of the factors which gives the minimum loss term value.}
\item{loss.grp}{A list of missclassification rates per hold-out sample}
\item{groups}{A vector defining the cross-validation groups which has been
used.}
\item{qhat}{The estimated out-of-sample predicted values in the 
cross-validation.}
\item{qhat.in}{The trained predicted values}
\item{param.grid}{ The matrix of all gridpoints which has been performed
during the cross-validation, with its corresponding weighted out-of-sample
missclassification rate.} \item{model}{ The \code{svmmaj}-object with the
estimated model using the optimal parameters found in the cross-validation.}
}
\description{
This function performs a gridsearch of k-fold cross-validations using SVM-Maj
and returns the combination of input values which has the best forecasting
performance.
}
\examples{

Xt <- diabetes$X
yt <- diabetes$y

## performing gridsearch with k-fold cross-validation
results <- svmmajcrossval(
   Xt, yt, 
  scale = 'interval',
  mc.cores = 2,
  ngroup = 5,
  return.model = TRUE
)

summary(results$model)
results
plot(results)
plot(results, 'profile')
}
\references{
P.J.F. Groenen, G. Nalbantov and J.C. Bioch (2008)
\emph{SVM-Maj: a majorization approach to linear support vector machines
with different hinge errors.}
}
\seealso{
\code{\link[SVMMaj]{svmmaj}}
}
\author{
Hok San Yip, Patrick J.F. Groenen, Georgi Nalbantov
}
