% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utm_select.R
\name{utm_select}
\alias{utm_select}
\title{Automatically convert geographic (degree) to planar coordinates (meters)}
\usage{
utm_select(x, max_zones = 5, return_list = FALSE)
}
\arguments{
\item{x}{Layer to be reprojected. \code{sf} or \code{RasterLayer} object.}

\item{max_zones}{Maximum number of UTM zones for single layer. Default is 5. Numeric.}

\item{return_list}{Return list object instead of reprojected layer (see Details). Default is \code{FALSE}. Logical.}
}
\value{
Re-projected layer. \code{sf} or \code{RasterLayer} object, depending on input.

If \code{return_list=TRUE}, returns a list object containing
\itemize{
 \item{"x_out". }{The re-projected layer. \code{sf} or \code{RasterLayer} object, depending on input.}
 \item{"proj4_best". }{proj4string of the projection. Character string.}
 }
}
\description{
Function to automatically convert simple feature and raster objects with geographic coordinates (longitude, latitude / WGS 1984, EPSG:4326) to planar UTM coordinates. If the study region spans multiple UTM zones, defaults to Albers Equal Area.
}
\details{
Optimal map projection for the object \code{x} is defined by matching its horizontal extent with that of the 60 UTM zones. If object spans multiple UTM zones, uses either the median zone (if number of zones is equal to or less than \code{max_zones}) or Albers Equal Area projection with median longitude as projection center (if number of zones is greater than \code{max_zones}).
}
\examples{
# Find a planar projection for an unprojected (WSG 1984) hexagonal grid of Germany
\dontrun{
data(hex_05_deu)
hex_tr <- utm_select(hex_05_deu)
}
}
