% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_projINLA.R
\name{plot.SUMMERproj}
\alias{plot.SUMMERproj}
\title{Plot projection output.}
\usage{
\method{plot}{SUMMERproj}(x, year_label = c("85-89", "90-94", "95-99",
  "00-04", "05-09", "10-14", "15-19"), year_med = c(1987, 1992, 1997,
  2002, 2007, 2012, 2017), is.subnational = TRUE, proj_year = 2015,
  data.add = NULL, option.add = list(point = NULL, lower = NULL, upper
  = NULL, by = NULL), color.add = "black", label.add = NULL,
  dodge.width = 1, plot.CI = NULL, per1000 = FALSE,
  color.CI = "black", alpha.CI = 0.3, ...)
}
\arguments{
\item{x}{output from \code{\link{getSmoothed}}}

\item{year_label}{labels for the periods}

\item{year_med}{labels for the middle years in each period}

\item{is.subnational}{logical indicator of whether the data contains subnational estimates}

\item{proj_year}{the first year where projections are made, i.e., where no data are available.}

\item{data.add}{data frame for the Comparisons data points to add to the graph. This can be, for example, the raw direct estimates. This data frame is merged to the projections by column 'region' and 'years'. Except for these two columns, this dataset should not have Comparisons columns with names overlapping the getSmoothed output.}

\item{option.add}{list of options specifying the variable names for the points to plot, lower and upper bounds, and the grouping variable. This is intended to be used to add Comparisons estimates on the same plot as the smoothed estimates. See examples for details.}

\item{color.add}{the color of the Comparisons data points to plot.}

\item{label.add}{the label of the Comparisons data points in the legend.}

\item{dodge.width}{the amount to add to data points at the same year to avoid overlap. Default to be 1.}

\item{plot.CI}{logical indicator of whether to plot the error bars.}

\item{per1000}{logical indicator to plot mortality rates as rates per 1,000 live births. Note that the added comparison data should always be in the probability scale.}

\item{color.CI}{the color of the error bars of the credible interval.}

\item{alpha.CI}{the alpha (transparency) of the error bars of the credible interval.}

\item{...}{optional arguments, see details}
}
\description{
Plot projection output.
}
\details{
Note that arguments after \code{...} must match exactly.
\itemize{
 \item{\code{year_label}}{string of year labels, defaults to \code{c("85-89", "90-94", "95-99", "00-04", "05-09", "10-14", "15-19")}}
 \item{\code{proj_year}}{projection year as numeric, defaults to \code{2015}}
 \item{\code{year_med}}{ median of year intervals, defaults to \code{c(1987, 1992, 1997, 2002, 2007, 2012, 2017)}}
 \item{\code{is.yearly}}{indicator for yearly model, defaults to \code{TRUE}}
 \item{\code{is.subnational}}{indicator for subnational model, defaults to \code{TRUE}}
}
}
\examples{
\dontrun{
years <- levels(DemoData[[1]]$time)

# obtain direct estimates
data <- getDirectList(births = DemoData, 
years = years,  
regionVar = "region", timeVar = "time", 
clusterVar = "~clustid+id", 
ageVar = "age", weightsVar = "weights", 
geo.recode = NULL)
# obtain direct estimates
data_multi <- getDirectList(births = DemoData, years = years,
  regionVar = "region",  timeVar = "time", clusterVar = "~clustid+id",
  ageVar = "age", weightsVar = "weights", geo.recode = NULL)
data <- aggregateSurvey(data_multi)

#  national model
years.all <- c(years, "15-19")
fit1 <- fitINLA(data = data, geo = NULL, Amat = NULL, 
  year_label = years.all, year_range = c(1985, 2019), 
  rw = 2, is.yearly=FALSE, m = 5)
out1 <- getSmoothed(fit1)
plot(out1, is.subnational=FALSE)

#  subnational model
fit2 <- fitINLA(data = data, geo = geo, Amat = mat, 
  year_label = years.all, year_range = c(1985, 2019), 
  rw = 2, is.yearly=TRUE, m = 5, type.st = 4)
out2 <- getSmoothed(fit2, Amat = mat)
plot(out2, is.yearly=TRUE, is.subnational=TRUE)


}

}
\seealso{
\code{\link{getSmoothed}}
}
