% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{sample.tt}
\alias{sample.tt}
\title{Sample one or more transmission trees uniformly}
\usage{
sample.tt(generator, count = 1, unsampled = 0, draw = count == 1,
  igraph = FALSE, verbose = FALSE)
}
\arguments{
\item{generator}{A list of class \code{tt.generator} produced by \code{tt.generator}.}

\item{count}{How many transmission trees to sample.}

\item{unsampled}{The number of unsampled hosts in the transmission chain.}

\item{draw}{Use \code{ggtree} to draw a coloured phylogeny showing each transmission tree overlaid onto the phylogeny.}

\item{igraph}{Produce the transmission trees in \code{igraph} format.}

\item{verbose}{Verbose output}
}
\value{
A list, each of whose elements is a list of class \code{tt} with one or more of the following elements:
\itemize{
\item{\code{annotations}}{ Always present. A vector indicating which host (given by numbers corresponding to the ordering in \code{generator$hosts}) is assigned to each phylogeny node.}
\item{\code{edgelist}}{ Always present. A \code{data.frame} giving the edge list; the first column are parents and the second children.}
\item{\code{hidden}}{ Present if \code{unsampled} is greater than 0. The number of "hidden" unsampled hosts (with no associated nodes) along each branch.}
\item{\code{picture}}{ Present if \code{draw} was TRUE; a \code{ggtree} object.}
\item{\code{igraph}}{ Present if \code{igraph} was TRUE; an \code{igraph} object.}
}
}
\description{
Sample one or more transmission trees uniformly
}
\examples{
# draw one sample from the uniform distribution
generator <- tt.generator(stratus.example.tree)
samples <- sample.tt(generator, 1, draw = TRUE)
samples[[1]]
# with unsampled.hosts
generator.us <- tt.generator(stratus.example.tree, max.unsampled = 2)
# note that you can ask for less unsampled hosts than the generator has (but not more)
samples.1us <- sample.tt(generator.us, 1, unsampled = 1,  draw = TRUE)
samples.1us[[1]]
# with multiply sampled hosts
generator.ms <- tt.generator(stratus.example.tree, tip.map = grouping.map)
samples.ms <- sample.tt(generator.ms, 1, draw = TRUE)
}
