% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_genotype_functions.R
\name{identifyNoise,stringCoverageList-method}
\alias{identifyNoise,stringCoverageList-method}
\title{Idenfities the noise.}
\usage{
\S4method{identifyNoise}{stringCoverageList}(
  stringCoverageListObject,
  colBelief = "Coverage",
  thresholdSignal = 0.01
)
}
\arguments{
\item{stringCoverageListObject}{an stringCoverageList-object, created using the \link{stringCoverage}-function.}

\item{colBelief}{the name of the coloumn used for identification.}

\item{thresholdSignal}{threshold applied to the signal (generally the coverage) of every string.}
}
\value{
Returns a list, with an element for every marker in stringCoverageList-object, each element contains the genotype for a given marker.
}
\description{
\code{identifyNoise} takes an stringCoverageList-object and identifies the noise based on a signal threshold for every marker in the provided list.
}
\examples{
# Strings aggregated by 'stringCoverage()'
data("stringCoverageList")

identifyNoise(stringCoverageList, thresholdSignal = 0.03)
}
