% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_func.R
\name{collapse}
\alias{collapse}
\title{Collapses a SpatialStreamNetwork object into a data frame}
\usage{
collapse(ssn, par = "afvArea")
}
\arguments{
\item{ssn}{An S4 SpatialStreamNetwork object created with SSN package.}

\item{par}{A spatial parameter such as the computed_afv (additive function value).}
}
\value{
A data frame with the lat and long of the line segments in the network. The column line_id refers to the ID of the line.
}
\description{
Collapses a SpatialStreamNetwork object into a data frame
}
\details{
The parameters (par) has to be present in the observed data frame via getSSNdata.frame(ssn, Name = "Obs"). More details of the argument par can be found in the SSN::additive.function().
}
\examples{
\donttest{
require("SSN")
path <- system.file("extdata/clearwater.ssn", package = "SSNbayes")
ssn <- importSSN(path, predpts = "preds", o.write = TRUE)
t.df <- collapse(ssn, par = 'afvArea')}
}
